/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.diagram.ProcessDiagramGenerator;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cmd.DeleteJobsCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.runtime.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnDeployer
implements Deployer {
    private static final Logger LOG = Logger.getLogger(BpmnDeployer.class.getName());
    public static final String[] BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    public static final String[] DIAGRAM_SUFFIXES = new String[]{"png", "jpg", "gif", "svg"};
    protected ExpressionManager expressionManager;
    protected BpmnParser bpmnParser;
    protected IdGenerator idGenerator;

    @Override
    public void deploy(DeploymentEntity deployment) {
        ArrayList<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
        Map<String, ResourceEntity> resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            LOG.info("Processing resource " + resourceName);
            if (!this.isBpmnResource(resourceName)) continue;
            ResourceEntity resource = resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            BpmnParse bpmnParse = this.bpmnParser.createParse().sourceInputStream(inputStream).deployment(deployment).name(resourceName);
            if (!deployment.isValidatingSchema()) {
                bpmnParse.setSchemaResource(null);
            }
            bpmnParse.execute();
            for (ProcessDefinitionEntity processDefinition : bpmnParse.getProcessDefinitions()) {
                processDefinition.setResourceName(resourceName);
                String diagramResourceName = this.getDiagramResourceForProcess(resourceName, processDefinition.getKey(), resources);
                if (deployment.isNew() && Context.getProcessEngineConfiguration().isCreateDiagramOnDeploy() && diagramResourceName == null && processDefinition.isGraphicalNotationDefined()) {
                    try {
                        byte[] diagramBytes = IoUtil.readInputStream(ProcessDiagramGenerator.generatePngDiagram(processDefinition), null);
                        diagramResourceName = this.getProcessImageResourceName(resourceName, processDefinition.getKey(), "png");
                        this.createResource(diagramResourceName, diagramBytes, deployment);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Error while generating process diagram, image will not be stored in repository", t);
                    }
                }
                processDefinition.setDiagramResourceName(diagramResourceName);
                processDefinitions.add(processDefinition);
            }
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
        for (ProcessDefinitionEntity processDefinition : processDefinitions) {
            if (deployment.isNew()) {
                ProcessDefinitionEntity latestProcessDefinition = processDefinitionManager.findLatestProcessDefinitionByKey(processDefinition.getKey());
                int processDefinitionVersion = latestProcessDefinition != null ? latestProcessDefinition.getVersion() + 1 : 1;
                processDefinition.setVersion(processDefinitionVersion);
                processDefinition.setDeploymentId(deployment.getId());
                String nextId = this.idGenerator.getNextId();
                String processDefinitionId = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nextId;
                if (processDefinitionId.length() > 64) {
                    processDefinitionId = nextId;
                }
                processDefinition.setId(processDefinitionId);
                this.removeObsoleteTimers(processDefinition);
                this.addTimerDeclarations(processDefinition);
                this.removeObsoleteMessageEventSubscriptions(processDefinition, latestProcessDefinition);
                this.addMessageEventSubscriptions(processDefinition);
                dbSqlSession.insert(processDefinition);
                deploymentCache.addProcessDefinition(processDefinition);
                this.addAuthorizations(processDefinition);
            } else {
                String deploymentId = deployment.getId();
                processDefinition.setDeploymentId(deploymentId);
                ProcessDefinitionEntity persistedProcessDefinition = processDefinitionManager.findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinition.getKey());
                processDefinition.setId(persistedProcessDefinition.getId());
                processDefinition.setVersion(persistedProcessDefinition.getVersion());
                deploymentCache.addProcessDefinition(processDefinition);
                this.addAuthorizations(processDefinition);
            }
            Context.getProcessEngineConfiguration().getDeploymentCache().addProcessDefinition(processDefinition);
        }
    }

    private void addTimerDeclarations(ProcessDefinitionEntity processDefinition) {
        List timerDeclarations = (List)processDefinition.getProperty("timerStart");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                TimerEntity timer = timerDeclaration.prepareTimerEntity(null);
                Context.getCommandContext().getJobManager().schedule(timer);
            }
        }
    }

    private void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        List<Job> jobsToDelete = Context.getCommandContext().getJobManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey());
        for (Job job : jobsToDelete) {
            new DeleteJobsCmd(job.getId()).execute(Context.getCommandContext());
        }
    }

    protected void removeObsoleteMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity latestProcessDefinition) {
        if (latestProcessDefinition != null) {
            CommandContext commandContext = Context.getCommandContext();
            List<EventSubscriptionEntity> subscriptionsToDelete = commandContext.getEventSubscriptionManager().findEventSubscriptionsByConfiguration("message", latestProcessDefinition.getId());
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
                eventSubscriptionEntity.delete();
            }
        }
    }

    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition) {
        CommandContext commandContext = Context.getCommandContext();
        List messageEventDefinitions = (List)processDefinition.getProperty("eventDefinitions");
        if (messageEventDefinitions != null) {
            for (EventSubscriptionDeclaration messageEventDefinition : messageEventDefinitions) {
                if (!messageEventDefinition.isStartEvent()) continue;
                List<EventSubscriptionEntity> subscriptionsForSameMessageName = commandContext.getEventSubscriptionManager().findEventSubscriptionsByName("message", messageEventDefinition.getEventName());
                List<MessageEventSubscriptionEntity> cachedSubscriptions = commandContext.getDbSqlSession().findInCache(MessageEventSubscriptionEntity.class);
                for (MessageEventSubscriptionEntity cachedSubscription : cachedSubscriptions) {
                    if (!messageEventDefinition.getEventName().equals(cachedSubscription.getEventName()) || subscriptionsForSameMessageName.contains(cachedSubscription)) continue;
                    subscriptionsForSameMessageName.add(cachedSubscription);
                }
                subscriptionsForSameMessageName = commandContext.getDbSqlSession().pruneDeletedEntities(subscriptionsForSameMessageName);
                if (!subscriptionsForSameMessageName.isEmpty()) {
                    throw new ActivitiException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + messageEventDefinition.getEventName() + "'.");
                }
                MessageEventSubscriptionEntity newSubscription = new MessageEventSubscriptionEntity();
                newSubscription.setEventName(messageEventDefinition.getEventName());
                newSubscription.setActivityId(messageEventDefinition.getActivityId());
                newSubscription.setConfiguration(processDefinition.getId());
                newSubscription.insert();
            }
        }
    }

    private void addAuthorizationsFromIterator(Set<Expression> exprSet, ProcessDefinitionEntity processDefinition, ExprType exprType) {
        CommandContext commandContext = Context.getCommandContext();
        if (exprSet != null) {
            for (Expression expr : exprSet) {
                IdentityLinkEntity identityLink = new IdentityLinkEntity();
                identityLink.setProcessDef(processDefinition);
                if (exprType.equals((Object)ExprType.USER)) {
                    identityLink.setUserId(expr.toString());
                } else if (exprType.equals((Object)ExprType.GROUP)) {
                    identityLink.setGroupId(expr.toString());
                }
                identityLink.setType("candidate");
                commandContext.getDbSqlSession().insert(identityLink);
            }
        }
    }

    protected void addAuthorizations(ProcessDefinitionEntity processDefinition) {
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterUserIdExpressions(), processDefinition, ExprType.USER);
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterGroupIdExpressions(), processDefinition, ExprType.GROUP);
    }

    protected String getDiagramResourceForProcess(String bpmnFileResource, String processKey, Map<String, ResourceEntity> resources) {
        for (String diagramSuffix : DIAGRAM_SUFFIXES) {
            String diagramForBpmnFileResource = this.getBpmnFileImageResourceName(bpmnFileResource, diagramSuffix);
            String processDiagramResource = this.getProcessImageResourceName(bpmnFileResource, processKey, diagramSuffix);
            if (resources.containsKey(processDiagramResource)) {
                return processDiagramResource;
            }
            if (!resources.containsKey(diagramForBpmnFileResource)) continue;
            return diagramForBpmnFileResource;
        }
        return null;
    }

    protected String getBpmnFileImageResourceName(String bpmnFileResource, String diagramSuffix) {
        String bpmnFileResourceBase = this.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + diagramSuffix;
    }

    protected String getProcessImageResourceName(String bpmnFileResource, String processKey, String diagramSuffix) {
        String bpmnFileResourceBase = this.stripBpmnFileSuffix(bpmnFileResource);
        return bpmnFileResourceBase + processKey + "." + diagramSuffix;
    }

    protected String stripBpmnFileSuffix(String bpmnFileResource) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!bpmnFileResource.endsWith(suffix)) continue;
            return bpmnFileResource.substring(0, bpmnFileResource.length() - suffix.length());
        }
        return bpmnFileResource;
    }

    protected void createResource(String name, byte[] bytes, DeploymentEntity deploymentEntity) {
        ResourceEntity resource = new ResourceEntity();
        resource.setName(name);
        resource.setBytes(bytes);
        resource.setDeploymentId(deploymentEntity.getId());
        resource.setGenerated(true);
        Context.getCommandContext().getDbSqlSession().insert(resource);
    }

    protected boolean isBpmnResource(String resourceName) {
        for (String suffix : BPMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public BpmnParser getBpmnParser() {
        return this.bpmnParser;
    }

    public void setBpmnParser(BpmnParser bpmnParser) {
        this.bpmnParser = bpmnParser;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExprType {
        USER,
        GROUP;

    }
}

