/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.listener;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.TaskListenerInvocation;

public class DelegateExpressionTaskListener
implements TaskListener {
    protected Expression expression;

    public DelegateExpressionTaskListener(Expression expression) {
        this.expression = expression;
    }

    public void notify(DelegateTask delegateTask) {
        Object delegate = this.expression.getValue(delegateTask.getExecution());
        if (delegate instanceof TaskListener) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new TaskListenerInvocation((TaskListener)delegate, delegateTask));
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while invoking TaskListener: " + e.getMessage(), e);
            }
        } else {
            throw new ActivitiException("Delegate expression " + this.expression + " did not resolve to an implementation of " + TaskListener.class);
        }
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }
}

