/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class EventSubscriptionDeclaration
implements Serializable {
    protected final String eventName;
    protected final String eventType;
    protected boolean async;
    protected String activityId;
    protected boolean isStartEvent;

    public EventSubscriptionDeclaration(String eventName, String eventType) {
        this.eventName = eventName;
        this.eventType = eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public boolean isStartEvent() {
        return this.isStartEvent;
    }

    public void setStartEvent(boolean isStartEvent) {
        this.isStartEvent = isStartEvent;
    }

    public String getEventType() {
        return this.eventType;
    }

    public EventSubscriptionEntity prepareEventSubscriptionEntity(ExecutionEntity execution) {
        EventSubscriptionEntity eventSubscriptionEntity = null;
        if (this.eventType.equals("message")) {
            eventSubscriptionEntity = new MessageEventSubscriptionEntity(execution);
        } else if (this.eventType.equals("signal")) {
            eventSubscriptionEntity = new SignalEventSubscriptionEntity(execution);
        } else {
            throw new ActivitiException("Found event definition of unknown type: " + this.eventType);
        }
        eventSubscriptionEntity.setEventName(this.eventName);
        if (this.activityId != null) {
            ActivityImpl activity = execution.getActivity().findActivity(this.activityId);
            eventSubscriptionEntity.setActivity(activity);
        }
        return eventSubscriptionEntity;
    }
}

