/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIdentityLinkForProcessDefinitionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String userId;
    protected String groupId;

    public AddIdentityLinkForProcessDefinitionCmd(String processDefinitionId, String userId, String groupId) {
        this.validateParams(userId, groupId, processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        this.userId = userId;
        this.groupId = groupId;
    }

    protected void validateParams(String userId, String groupId, String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new ActivitiException("processDefinitionId is null");
        }
        if (userId == null && groupId == null) {
            throw new ActivitiException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiException("Cannot find process definition with id " + this.processDefinitionId);
        }
        processDefinition.addIdentityLink(this.userId, this.groupId);
        return null;
    }
}

