/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.ClockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteIdentityLinkCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String userId;
    protected String groupId;
    protected String type;

    public DeleteIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (taskId == null) {
            throw new ActivitiException("taskId is null");
        }
        if (type == null) {
            throw new ActivitiException("type is required when adding a new task identity link");
        }
        if ("assignee".equals(type) || "owner".equals(type)) {
            if (groupId != null) {
                throw new ActivitiException("Incompatible usage: cannot use type '" + type + "' together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new ActivitiException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException("Cannot find task with id " + this.taskId);
        }
        if ("assignee".equals(this.type)) {
            task.setAssignee(null);
        } else if ("owner".equals(this.type)) {
            task.setOwner(null);
        } else {
            task.deleteIdentityLink(this.userId, this.groupId, this.type);
        }
        CommentManager commentManager = commandContext.getCommentManager();
        if (commentManager.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = new CommentEntity();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(ClockUtil.getCurrentTime());
            comment.setTaskId(this.taskId);
            if (this.userId != null) {
                comment.setAction("DeleteUserLink");
                comment.setMessage(new String[]{this.userId, this.type});
            } else {
                comment.setAction("DeleteGroupLink");
                comment.setMessage(new String[]{this.groupId, this.type});
            }
            commentManager.insert(comment);
        }
        return null;
    }
}

