/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageEventReceivedCmd
implements Command<Void> {
    protected final Map<String, Object> processVariables;
    protected final String messageName;
    protected final String executionId;

    public MessageEventReceivedCmd(String messageName, String executionId, Map<String, Object> processVariables) {
        this.messageName = messageName;
        this.executionId = executionId;
        this.processVariables = processVariables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.messageName == null) {
            throw new ActivitiException("messageName cannot be null");
        }
        if (this.executionId == null) {
            throw new ActivitiException("executionId cannot be null");
        }
        List<EventSubscriptionEntity> eventSubscriptions = commandContext.getEventSubscriptionManager().findEventSubscriptionsByNameAndExecution("message", this.messageName, this.executionId);
        if (eventSubscriptions.isEmpty()) {
            throw new ActivitiException("Execution with id '" + this.executionId + "' does not have a subscription to a message event with name '" + this.messageName + "'");
        }
        EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptions.get(0);
        HashMap<String, Object> payload = null;
        if (this.processVariables != null) {
            payload = new HashMap<String, Object>(this.processVariables);
        }
        eventSubscriptionEntity.eventReceived(payload, false);
        return null;
    }
}

