/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetProcessDefinitionVersionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String processInstanceId;
    private final Integer processDefinitionVersion;

    public SetProcessDefinitionVersionCmd(String processInstanceId, Integer processDefinitionVersion) {
        if (processInstanceId == null || processInstanceId.length() < 1) {
            throw new ActivitiException("The process instance id is mandatory, but '" + processInstanceId + "' has been provided.");
        }
        if (processDefinitionVersion == null) {
            throw new ActivitiException("The process definition version is mandatory, but 'null' has been provided.");
        }
        if (processDefinitionVersion < 1) {
            throw new ActivitiException("The process definition version must be positive, but '" + processDefinitionVersion + "' has been provided.");
        }
        this.processInstanceId = processInstanceId;
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ActivitiException("No process instance found for id = '" + this.processInstanceId + "'.");
        }
        if (!processInstance.isProcessInstance()) {
            throw new ActivitiException("A process instance id is required, but the provided id '" + this.processInstanceId + "' " + "points to a child execution of process instance " + "'" + processInstance.getProcessInstanceId() + "'. " + "Please invoke the " + this.getClass().getSimpleName() + " with a root execution id.");
        }
        ProcessDefinitionImpl currentProcessDefinitionImpl = processInstance.getProcessDefinition();
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity currentProcessDefinition = currentProcessDefinitionImpl instanceof ProcessDefinitionEntity ? (ProcessDefinitionEntity)currentProcessDefinitionImpl : deploymentCache.findDeployedProcessDefinitionById(currentProcessDefinitionImpl.getId());
        ProcessDefinitionEntity newProcessDefinition = deploymentCache.findDeployedProcessDefinitionByKeyAndVersion(currentProcessDefinition.getKey(), this.processDefinitionVersion);
        this.validateAndSwitchVersionOfExecution(processInstance, newProcessDefinition);
        HistoricProcessInstanceManager historicProcessInstanceManager = commandContext.getHistoricProcessInstanceManager();
        if (historicProcessInstanceManager.isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance = historicProcessInstanceManager.findHistoricProcessInstance(this.processInstanceId);
            historicProcessInstance.setProcessDefinitionId(newProcessDefinition.getId());
        }
        List<ExecutionEntity> childExecutions = executionManager.findChildExecutionsByParentExecutionId(this.processInstanceId);
        for (ExecutionEntity executionEntity : childExecutions) {
            this.validateAndSwitchVersionOfExecution(executionEntity, newProcessDefinition);
        }
        return null;
    }

    protected void validateAndSwitchVersionOfExecution(ExecutionEntity execution, ProcessDefinitionEntity newProcessDefinition) {
        if (execution.getActivity() != null && !newProcessDefinition.contains(execution.getActivity())) {
            throw new ActivitiException("The new process definition (key = '" + newProcessDefinition.getKey() + "') " + "does not contain the current activity " + "(id = '" + execution.getActivity().getId() + "') " + "of the process instance " + "(id = '" + this.processInstanceId + "').");
        }
        execution.setProcessDefinition(newProcessDefinition);
    }
}

