/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitTaskFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, String> properties;

    public SubmitTaskFormCmd(String taskId, Map<String, String> properties) {
        this.taskId = taskId;
        this.properties = properties;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiException("taskId is null");
        }
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException("Cannot find task with id " + this.taskId);
        }
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        ExecutionEntity execution = task.getExecution();
        if (historyLevel >= 2 && execution != null) {
            DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
            for (String propertyId : this.properties.keySet()) {
                String propertyValue = this.properties.get(propertyId);
                HistoricFormPropertyEntity historicFormProperty = new HistoricFormPropertyEntity(execution, propertyId, propertyValue, this.taskId);
                dbSqlSession.insert(historicFormProperty);
            }
        }
        TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
        taskFormHandler.submitFormProperties(this.properties, task.getExecution());
        task.complete();
        return null;
    }
}

