/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public abstract class AbstractEventHandler
implements EventHandler {
    private static Logger log = Logger.getLogger(AbstractEventHandler.class.getName());

    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        ExecutionEntity execution = eventSubscription.getExecution();
        ActivityImpl activity = eventSubscription.getActivity();
        if (activity == null) {
            throw new ActivitiException("Error while sending signal for event subscription '" + eventSubscription.getId() + "': " + "no activity associated with event subscription");
        }
        if (!activity.equals(execution.getActivity())) {
            execution.setActivity(activity);
        }
        if (payload instanceof Map) {
            Map processVariables = (Map)payload;
            execution.setVariables(processVariables);
        }
        if (activity.getActivityBehavior() instanceof BoundaryEventActivityBehavior) {
            try {
                activity.getActivityBehavior().execute(execution);
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "exception while sending signal for event subscription '" + eventSubscription + "'", e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "exception while sending signal for event subscription '" + eventSubscription + "'", e);
                throw new ActivitiException("exception while sending signal for event subscription '" + eventSubscription + "':" + e.getMessage(), e);
            }
        } else {
            execution.signal("signal", null);
        }
    }
}

