/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.form.FormData;
import org.activiti.engine.form.StartFormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.form.FormEngine;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.scripting.ScriptingEngines;

public class JuelFormEngine
implements FormEngine {
    public String getName() {
        return "juel";
    }

    public Object renderStartForm(StartFormData startForm) {
        if (startForm.getFormKey() == null) {
            return null;
        }
        String formTemplateString = this.getFormTemplateString(startForm);
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        return scriptingEngines.evaluate(formTemplateString, "juel", null);
    }

    public Object renderTaskForm(TaskFormData taskForm) {
        if (taskForm.getFormKey() == null) {
            return null;
        }
        String formTemplateString = this.getFormTemplateString(taskForm);
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        TaskEntity task = (TaskEntity)taskForm.getTask();
        return scriptingEngines.evaluate(formTemplateString, "juel", task.getExecution());
    }

    protected String getFormTemplateString(FormData formInstance) {
        String deploymentId = formInstance.getDeploymentId();
        String formKey = formInstance.getFormKey();
        ResourceEntity resourceStream = Context.getCommandContext().getResourceManager().findResourceByDeploymentIdAndResourceName(deploymentId, formKey);
        if (resourceStream == null) {
            throw new ActivitiException("Form with formKey '" + formKey + "' does not exist");
        }
        byte[] resourceBytes = resourceStream.getBytes();
        String formTemplateString = new String(resourceBytes);
        return formTemplateString;
    }
}

