/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.activiti.engine.impl.persistence.entity.AttachmentManager;
import org.activiti.engine.impl.persistence.entity.CommentManager;
import org.activiti.engine.impl.persistence.entity.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionManager;
import org.activiti.engine.impl.persistence.entity.GroupManager;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import org.activiti.engine.impl.persistence.entity.HistoricDetailManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkManager;
import org.activiti.engine.impl.persistence.entity.JobManager;
import org.activiti.engine.impl.persistence.entity.MembershipManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.activiti.engine.impl.persistence.entity.PropertyManager;
import org.activiti.engine.impl.persistence.entity.ResourceManager;
import org.activiti.engine.impl.persistence.entity.TableDataManager;
import org.activiti.engine.impl.persistence.entity.TaskManager;
import org.activiti.engine.impl.persistence.entity.UserManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceManager;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandContext {
    private static Logger log = Logger.getLogger(CommandContext.class.getName());
    protected Command<?> command;
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected Throwable exception = null;
    protected LinkedList<AtomicOperation> nextOperations = new LinkedList();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FailedJobCommandFactory failedJobCommandFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(AtomicOperation executionOperation, InterpretableExecution execution) {
        this.nextOperations.add(executionOperation);
        if (this.nextOperations.size() == 1) {
            try {
                Context.setExecutionContext(execution);
                while (!this.nextOperations.isEmpty()) {
                    AtomicOperation currentOperation = this.nextOperations.removeFirst();
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("AtomicOperation: " + currentOperation + " on " + this);
                    }
                    currentOperation.execute(execution);
                }
            }
            finally {
                Context.removeExecutionContext();
            }
        }
    }

    public CommandContext(Command<?> command, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.command = command;
        this.processEngineConfiguration = processEngineConfiguration;
        this.failedJobCommandFactory = processEngineConfiguration.getFailedJobCommandFactory();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContext = processEngineConfiguration.getTransactionContextFactory().openTransactionContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block26: {
            try {
                try {
                    try {
                        if (this.exception == null) {
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            this.exception(exception);
                            break block26;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (this.exception == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                this.exception(exception2);
                            }
                            if (this.exception != null) {
                                Level loggingLevel = Level.SEVERE;
                                if (this.exception instanceof ActivitiTaskAlreadyClaimedException) {
                                    loggingLevel = Level.INFO;
                                }
                                log.log(loggingLevel, "Error while closing command context", this.exception);
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (this.exception == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        this.exception(exception);
                    }
                    if (this.exception != null) {
                        Level loggingLevel = Level.SEVERE;
                        if (this.exception instanceof ActivitiTaskAlreadyClaimedException) {
                            loggingLevel = Level.INFO;
                        }
                        log.log(loggingLevel, "Error while closing command context", this.exception);
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    this.exception(exception);
                }
                finally {
                    this.closeSessions();
                }
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
        if (this.exception == null) return;
        if (this.exception instanceof Error) {
            throw (Error)this.exception;
        }
        if (!(this.exception instanceof RuntimeException)) throw new ActivitiException("exception while executing command " + this.command, this.exception);
        throw (RuntimeException)this.exception;
    }

    protected void flushSessions() {
        for (Session session : this.sessions.values()) {
            session.flush();
        }
    }

    protected void closeSessions() {
        for (Session session : this.sessions.values()) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                this.exception(exception);
            }
        }
    }

    public void exception(Throwable exception) {
        if (this.exception == null) {
            this.exception = exception;
        } else {
            log.log(Level.SEVERE, "masked exception in command context. for root cause, see below as it will be rethrown later.", exception);
        }
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            if (sessionFactory == null) {
                throw new ActivitiException("no session factory configured for " + sessionClass.getName());
            }
            session = sessionFactory.openSession();
            this.sessions.put(sessionClass, session);
        }
        return (T)session;
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public DeploymentManager getDeploymentManager() {
        return this.getSession(DeploymentManager.class);
    }

    public ResourceManager getResourceManager() {
        return this.getSession(ResourceManager.class);
    }

    public ProcessDefinitionManager getProcessDefinitionManager() {
        return this.getSession(ProcessDefinitionManager.class);
    }

    public ExecutionManager getExecutionManager() {
        return this.getSession(ExecutionManager.class);
    }

    public TaskManager getTaskManager() {
        return this.getSession(TaskManager.class);
    }

    public IdentityLinkManager getIdentityLinkManager() {
        return this.getSession(IdentityLinkManager.class);
    }

    public VariableInstanceManager getVariableInstanceManager() {
        return this.getSession(VariableInstanceManager.class);
    }

    public HistoricProcessInstanceManager getHistoricProcessInstanceManager() {
        return this.getSession(HistoricProcessInstanceManager.class);
    }

    public HistoricDetailManager getHistoricDetailManager() {
        return this.getSession(HistoricDetailManager.class);
    }

    public HistoricActivityInstanceManager getHistoricActivityInstanceManager() {
        return this.getSession(HistoricActivityInstanceManager.class);
    }

    public HistoricTaskInstanceManager getHistoricTaskInstanceManager() {
        return this.getSession(HistoricTaskInstanceManager.class);
    }

    public JobManager getJobManager() {
        return this.getSession(JobManager.class);
    }

    public UserManager getUserManager() {
        return this.getSession(UserManager.class);
    }

    public GroupManager getGroupManager() {
        return this.getSession(GroupManager.class);
    }

    public IdentityInfoManager getIdentityInfoManager() {
        return this.getSession(IdentityInfoManager.class);
    }

    public MembershipManager getMembershipManager() {
        return this.getSession(MembershipManager.class);
    }

    public AttachmentManager getAttachmentManager() {
        return this.getSession(AttachmentManager.class);
    }

    public TableDataManager getTableDataManager() {
        return this.getSession(TableDataManager.class);
    }

    public CommentManager getCommentManager() {
        return this.getSession(CommentManager.class);
    }

    public EventSubscriptionManager getEventSubscriptionManager() {
        return this.getSession(EventSubscriptionManager.class);
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public PropertyManager getPropertyManager() {
        return this.getSession(PropertyManager.class);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public Throwable getException() {
        return this.exception;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }
}

