/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.impl.jobexecutor.ExecuteJobsRunnable;
import org.activiti.engine.impl.jobexecutor.JobExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJobExecutor
extends JobExecutor {
    private static Logger log = Logger.getLogger(DefaultJobExecutor.class.getName());
    protected int queueSize = 3;
    protected int corePoolSize = 3;
    private int maxPoolSize = 10;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ThreadPoolExecutor threadPoolExecutor;

    @Override
    protected void startExecutingJobs() {
        if (this.threadPoolQueue == null) {
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.threadPoolExecutor == null) {
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, this.threadPoolQueue);
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        }
        this.startJobAcquisitionThread();
    }

    @Override
    protected void stopExecutingJobs() {
        this.stopJobAcquisitionThread();
        this.threadPoolExecutor.shutdown();
        try {
            if (!this.threadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.log(Level.WARNING, "Timeout during shutdown of job executor. The current running jobs could not end within 60 seconds after shutdown operation.");
            }
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted while shutting down the job executor. ", e);
        }
        this.threadPoolExecutor = null;
    }

    @Override
    public void executeJobs(List<String> jobIds) {
        try {
            this.threadPoolExecutor.execute(new ExecuteJobsRunnable(this, jobIds));
        }
        catch (RejectedExecutionException e) {
            this.rejectedJobsHandler.jobsRejected(this, jobIds);
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }
}

