/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationType;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.ClockUtil;

public class TimerDeclarationImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Expression description;
    protected TimerDeclarationType type;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration = null;
    protected String repeat;
    protected boolean exclusive = true;
    protected int retries = 3;

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
        this.description = expression;
        this.type = type;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public TimerEntity prepareTimerEntity(ExecutionEntity executionEntity) {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.type.caledarName);
        if (this.description == null) {
            throw new ActivitiException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time");
        }
        String dueDateString = null;
        Date duedate = null;
        if (executionEntity == null) {
            dueDateString = this.description.getExpressionText();
        } else {
            Object dueDateValue = this.description.getValue(executionEntity);
            if (dueDateValue instanceof String) {
                dueDateString = (String)dueDateValue;
            } else if (dueDateValue instanceof Date) {
                duedate = (Date)dueDateValue;
            } else {
                throw new ActivitiException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
            }
        }
        if (duedate == null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        TimerEntity timer = new TimerEntity(this);
        timer.setDuedate(duedate);
        if (executionEntity != null) {
            timer.setExecution(executionEntity);
        }
        if (this.type == TimerDeclarationType.CYCLE) {
            String prepared = this.prepareRepeat(dueDateString);
            timer.setRepeat(prepared);
        }
        return timer;
    }

    private String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dueDate.replace("/", "/" + sdf.format(ClockUtil.getCurrentTime()) + "/");
        }
        return dueDate;
    }
}

