/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.repository.Deployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentEntity
implements Serializable,
Deployment,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected Map<String, ResourceEntity> resources;
    protected Date deploymentTime;
    protected boolean validatingSchema = true;
    protected boolean isNew;

    public ResourceEntity getResource(String resourceName) {
        return this.getResources().get(resourceName);
    }

    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, ResourceEntity>();
        }
        this.resources.put(resource.getName(), resource);
    }

    public Map<String, ResourceEntity> getResources() {
        if (this.resources == null && this.id != null) {
            List<ResourceEntity> resourcesList = Context.getCommandContext().getResourceManager().findResourcesByDeploymentId(this.id);
            this.resources = new HashMap<String, ResourceEntity>();
            for (ResourceEntity resource : resourcesList) {
                this.resources.put(resource.getName(), resource);
            }
        }
        return this.resources;
    }

    @Override
    public Object getPersistentState() {
        return DeploymentEntity.class;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResources(Map<String, ResourceEntity> resources) {
        this.resources = resources;
    }

    @Override
    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }
}

