/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.impl.EventSubscriptionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSubscriptionManager
extends AbstractManager {
    protected List<SignalEventSubscriptionEntity> createdSignalSubscriptions = new ArrayList<SignalEventSubscriptionEntity>();

    public void insert(EventSubscriptionEntity persistentObject) {
        super.insert(persistentObject);
        if (persistentObject instanceof SignalEventSubscriptionEntity) {
            this.createdSignalSubscriptions.add((SignalEventSubscriptionEntity)persistentObject);
        }
    }

    public void deleteEventSubscription(EventSubscriptionEntity persistentObject) {
        this.getDbSqlSession().delete(persistentObject.getClass(), persistentObject.getId());
        if (persistentObject instanceof SignalEventSubscriptionEntity) {
            this.createdSignalSubscriptions.remove(persistentObject);
        }
    }

    public EventSubscriptionEntity findEventSubscriptionbyId(String id) {
        return (EventSubscriptionEntity)this.getDbSqlSession().selectOne("selectEventSubscription", id);
    }

    public long findEventSubscriptionCountByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl) {
        String query = "selectEventSubscriptionCountByQueryCriteria";
        return (Long)this.getDbSqlSession().selectOne("selectEventSubscriptionCountByQueryCriteria", eventSubscriptionQueryImpl);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl, Page page) {
        String query = "selectEventSubscriptionByQueryCriteria";
        return this.getDbSqlSession().selectList("selectEventSubscriptionByQueryCriteria", eventSubscriptionQueryImpl, page);
    }

    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByEventName(String eventName) {
        String query = "selectSignalEventSubscriptionsByEventName";
        HashSet<SignalEventSubscriptionEntity> selectList = new HashSet<SignalEventSubscriptionEntity>(this.getDbSqlSession().selectList("selectSignalEventSubscriptionsByEventName", eventName));
        for (SignalEventSubscriptionEntity entity : this.createdSignalSubscriptions) {
            if (!eventName.equals(entity.getEventName())) continue;
            selectList.add(entity);
        }
        return new ArrayList<SignalEventSubscriptionEntity>(selectList);
    }

    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByExecution(String executionId) {
        String query = "selectSignalEventSubscriptionsByExecution";
        HashSet<SignalEventSubscriptionEntity> selectList = new HashSet<SignalEventSubscriptionEntity>(this.getDbSqlSession().selectList("selectSignalEventSubscriptionsByExecution", executionId));
        for (SignalEventSubscriptionEntity entity : this.createdSignalSubscriptions) {
            if (!executionId.equals(entity.getExecutionId())) continue;
            selectList.add(entity);
        }
        return new ArrayList<SignalEventSubscriptionEntity>(selectList);
    }

    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByNameAndExecution(String name, String executionId) {
        String query = "selectSignalEventSubscriptionsByNameAndExecution";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventName", name);
        HashSet<SignalEventSubscriptionEntity> selectList = new HashSet<SignalEventSubscriptionEntity>(this.getDbSqlSession().selectList("selectSignalEventSubscriptionsByNameAndExecution", params));
        for (SignalEventSubscriptionEntity entity : this.createdSignalSubscriptions) {
            if (!executionId.equals(entity.getExecutionId()) || !name.equals(entity.getEventName())) continue;
            selectList.add(entity);
        }
        return new ArrayList<SignalEventSubscriptionEntity>(selectList);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByExecutionAndType(String executionId, String type) {
        String query = "selectEventSubscriptionsByExecutionAndType";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventType", type);
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByExecutionAndType", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByExecution(String executionId) {
        String query = "selectEventSubscriptionsByExecution";
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByExecution", executionId);
    }

    public List<EventSubscriptionEntity> findEventSubscriptions(String executionId, String type, String activityId) {
        String query = "selectEventSubscriptionsByExecutionTypeAndActivity";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventType", type);
        params.put("activityId", activityId);
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByExecutionTypeAndActivity", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByConfiguration(String type, String configuration) {
        String query = "selectEventSubscriptionsByConfiguration";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("configuration", configuration);
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByConfiguration", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByName(String type, String eventName) {
        String query = "selectEventSubscriptionsByName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("eventName", eventName);
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByName", params);
    }

    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndExecution(String type, String eventName, String executionId) {
        String query = "selectEventSubscriptionsByNameAndExecution";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("eventName", eventName);
        params.put("executionId", executionId);
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByNameAndExecution", params);
    }

    public MessageEventSubscriptionEntity findMessageStartEventSubscriptionByName(String messageName) {
        MessageEventSubscriptionEntity entity = (MessageEventSubscriptionEntity)this.getDbSqlSession().selectOne("selectMessageStartEventSubscriptionByName", messageName);
        return entity;
    }
}

