/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.ExecutionVariableQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionManager
extends AbstractManager {
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List processInstanceIds = this.getDbSqlSession().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            Context.getCommandContext().getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution == null) {
            throw new ActivitiException("No process instance found for id '" + processInstanceId + "'");
        }
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getTaskManager().deleteTasksByProcessInstanceId(processInstanceId, deleteReason, cascade);
        if (cascade) {
            commandContext.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(processInstanceId);
        }
        execution.deleteCascade(deleteReason);
    }

    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return (ExecutionEntity)this.getDbSqlSession().selectOne("selectSubProcessInstanceBySuperExecutionId", superExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parentExecutionId);
    }

    public ExecutionEntity findExecutionById(String executionId) {
        return this.getDbSqlSession().selectById(ExecutionEntity.class, executionId);
    }

    public long findExecutionCountByQueryCriteria(ExecutionVariableQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionVariableQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    public long findProcessInstanceCountByQueryCriteria(ExecutionVariableQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessInstanceCountByQueryCriteria", executionQuery);
    }

    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ExecutionVariableQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectProcessInstanceByQueryCriteria", executionQuery, page);
    }

    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put("parentExecutionId", parentExecutionId);
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parameters);
    }
}

