/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.ProcessElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionImpl
extends ProcessElementImpl
implements PvmTransition {
    private static final long serialVersionUID = 1L;
    protected ActivityImpl source;
    protected ActivityImpl destination;
    protected List<ExecutionListener> executionListeners;
    protected List<Integer> waypoints = new ArrayList<Integer>();

    public TransitionImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id, processDefinition);
    }

    @Override
    public ActivityImpl getSource() {
        return this.source;
    }

    public void setDestination(ActivityImpl destination) {
        this.destination = destination;
        destination.getIncomingTransitions().add(this);
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        if (this.executionListeners == null) {
            this.executionListeners = new ArrayList<ExecutionListener>();
        }
        this.executionListeners.add(executionListener);
    }

    public String toString() {
        return "(" + this.source.getId() + ")--" + (this.id != null ? this.id + "-->(" : ">(") + this.destination.getId() + ")";
    }

    public List<ExecutionListener> getExecutionListeners() {
        if (this.executionListeners == null) {
            return Collections.EMPTY_LIST;
        }
        return this.executionListeners;
    }

    protected void setSource(ActivityImpl source) {
        this.source = source;
    }

    @Override
    public ActivityImpl getDestination() {
        return this.destination;
    }

    public void setExecutionListeners(List<ExecutionListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    public List<Integer> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<Integer> waypoints) {
        this.waypoints = waypoints;
    }
}

