/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.xml;

import java.util.Stack;
import java.util.logging.Logger;
import org.activiti.engine.impl.util.xml.Element;
import org.activiti.engine.impl.util.xml.Parse;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseHandler
extends DefaultHandler {
    private static Logger log = Logger.getLogger(ParseHandler.class.getName());
    protected String defaultNamespace;
    protected Parse parse;
    protected Locator locator;
    protected Stack<Element> elementStack = new Stack();

    public ParseHandler(Parse parse) {
        this.parse = parse;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element element = new Element(uri, localName, qName, attributes, this.locator);
        if (this.elementStack.isEmpty()) {
            this.parse.rootElement = element;
        } else {
            this.elementStack.peek().add(element);
        }
        this.elementStack.push(element);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.elementStack.peek().appendText(String.valueOf(ch, start, length));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elementStack.pop();
    }

    public void error(SAXParseException e) {
        this.parse.addError(e);
    }

    public void fatalError(SAXParseException e) {
        this.parse.addError(e);
    }

    public void warning(SAXParseException e) {
        log.warning(e.toString());
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }
}

