/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import javax.persistence.EntityManagerFactory;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.engine.impl.variable.EntityManagerSession;
import org.activiti.engine.impl.variable.EntityManagerSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerSessionFactory
implements SessionFactory {
    protected EntityManagerFactory entityManagerFactory;
    protected boolean handleTransactions;
    protected boolean closeEntityManager;

    public EntityManagerSessionFactory(Object entityManagerFactory, boolean handleTransactions, boolean closeEntityManager) {
        if (entityManagerFactory == null) {
            throw new ActivitiException("entityManagerFactory is null");
        }
        if (!(entityManagerFactory instanceof EntityManagerFactory)) {
            throw new ActivitiException("EntityManagerFactory must implement 'javax.persistence.EntityManagerFactory'");
        }
        this.entityManagerFactory = (EntityManagerFactory)entityManagerFactory;
        this.handleTransactions = handleTransactions;
        this.closeEntityManager = closeEntityManager;
    }

    @Override
    public Class<?> getSessionType() {
        return EntityManagerSession.class;
    }

    @Override
    public Session openSession() {
        return new EntityManagerSessionImpl(this.entityManagerFactory, this.handleTransactions, this.closeEntityManager);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }
}

