/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.variable.ByteArrayType;
import org.activiti.engine.impl.variable.ValueFields;

public class SerializableType
extends ByteArrayType {
    public static final String TYPE_NAME = "serializable";
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return TYPE_NAME;
    }

    public Object getValue(ValueFields valueFields) {
        Object deserializedObject;
        Object cachedObject = valueFields.getCachedValue();
        if (cachedObject != null) {
            return cachedObject;
        }
        byte[] bytes = (byte[])super.getValue(valueFields);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            deserializedObject = ois.readObject();
            valueFields.setCachedValue(deserializedObject);
            if (valueFields instanceof VariableInstanceEntity) {
                Context.getCommandContext().getDbSqlSession().addDeserializedObject(deserializedObject, bytes, (VariableInstanceEntity)valueFields);
            }
        }
        catch (Exception e) {
            throw new ActivitiException("coudn't deserialize object in variable '" + valueFields.getName() + "'", e);
        }
        finally {
            IoUtil.closeSilently(bais);
        }
        return deserializedObject;
    }

    public void setValue(Object value, ValueFields valueFields) {
        byte[] byteArray = SerializableType.serialize(value, valueFields);
        valueFields.setCachedValue(value);
        if (valueFields.getByteArrayValue() == null && valueFields instanceof VariableInstanceEntity) {
            Context.getCommandContext().getDbSqlSession().addDeserializedObject(valueFields.getCachedValue(), byteArray, (VariableInstanceEntity)valueFields);
        }
        super.setValue(byteArray, valueFields);
    }

    public static byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream ois = null;
        try {
            ois = new ObjectOutputStream(baos);
            ois.writeObject(value);
        }
        catch (Exception e) {
            try {
                throw new ActivitiException("coudn't serialize value '" + value + "' in variable '" + valueFields.getName() + "'", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(ois);
                throw throwable;
            }
        }
        IoUtil.closeSilently(ois);
        return baos.toByteArray();
    }

    public boolean isAbleToStore(Object value) {
        return value instanceof Serializable;
    }
}

