/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.springframework.core.GenericTypeResolver;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.DuplicateConnectionException;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.ConnectInterceptor;
import org.springframework.social.connect.web.ConnectSupport;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.view.RedirectView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/connect"})
public class ConnectController {
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final ConnectionRepository connectionRepository;
    private final MultiValueMap<Class<?>, ConnectInterceptor<?>> interceptors = new LinkedMultiValueMap();
    private final ConnectSupport webSupport = new ConnectSupport();
    private static final String DUPLICATE_CONNECTION_ATTRIBUTE = "social.addConnection.duplicate";

    @Inject
    public ConnectController(ConnectionFactoryLocator connectionFactoryLocator, ConnectionRepository connectionRepository) {
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.connectionRepository = connectionRepository;
    }

    public void setInterceptors(List<ConnectInterceptor<?>> interceptors) {
        for (ConnectInterceptor<?> interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    public void setApplicationUrl(URL applicationUrl) {
        this.webSupport.setApplicationUrl(applicationUrl);
    }

    public void addInterceptor(ConnectInterceptor<?> interceptor) {
        Class serviceApiType = GenericTypeResolver.resolveTypeArgument(interceptor.getClass(), ConnectInterceptor.class);
        this.interceptors.add((Object)serviceApiType, interceptor);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String connectionStatus(WebRequest request, Model model) {
        MultiValueMap connections = this.connectionRepository.findAllConnections();
        model.addAttribute("providerIds", (Object)this.connectionFactoryLocator.registeredProviderIds());
        model.addAttribute("connectionMap", (Object)connections);
        return this.connectView("status");
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET})
    public String connectionStatus(@PathVariable String providerId, WebRequest request, Model model) {
        this.processFlash(request, model);
        List connections = this.connectionRepository.findConnections(providerId);
        if (connections.isEmpty()) {
            return this.connectView(providerId + "Connect");
        }
        model.addAttribute("connections", (Object)connections);
        return this.connectView(providerId + "Connected");
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.POST})
    public RedirectView connect(@PathVariable String providerId, NativeWebRequest request) {
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(providerId);
        this.preConnect(connectionFactory, (WebRequest)request);
        return new RedirectView(this.webSupport.buildOAuthUrl(connectionFactory, request));
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"oauth_token"})
    public RedirectView oauth1Callback(@PathVariable String providerId, NativeWebRequest request) {
        OAuth1ConnectionFactory connectionFactory = (OAuth1ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
        Connection<?> connection = this.webSupport.completeConnection(connectionFactory, request);
        this.addConnection(connection, (ConnectionFactory<?>)connectionFactory, (WebRequest)request);
        return this.connectionStatusRedirect(providerId);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.GET}, params={"code"})
    public RedirectView oauth2Callback(@PathVariable String providerId, NativeWebRequest request) {
        OAuth2ConnectionFactory connectionFactory = (OAuth2ConnectionFactory)this.connectionFactoryLocator.getConnectionFactory(providerId);
        Connection<?> connection = this.webSupport.completeConnection(connectionFactory, request);
        this.addConnection(connection, (ConnectionFactory<?>)connectionFactory, (WebRequest)request);
        return this.connectionStatusRedirect(providerId);
    }

    @RequestMapping(value={"/{providerId}"}, method={RequestMethod.DELETE})
    public RedirectView removeConnections(@PathVariable String providerId) {
        this.connectionRepository.removeConnections(providerId);
        return this.connectionStatusRedirect(providerId);
    }

    @RequestMapping(value={"/{providerId}/{providerUserId}"}, method={RequestMethod.DELETE})
    public RedirectView removeConnection(@PathVariable String providerId, @PathVariable String providerUserId) {
        this.connectionRepository.removeConnection(new ConnectionKey(providerId, providerUserId));
        return this.connectionStatusRedirect(providerId);
    }

    private String getControllerPath() {
        return "/connect";
    }

    private String getViewPath() {
        return "connect/";
    }

    private String connectView(String name) {
        return this.getViewPath() + name;
    }

    private void addConnection(Connection<?> connection, ConnectionFactory<?> connectionFactory, WebRequest request) {
        try {
            this.connectionRepository.addConnection(connection);
            this.postConnect(connectionFactory, connection, request);
        }
        catch (DuplicateConnectionException e) {
            request.setAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, (Object)e, 1);
        }
    }

    private void preConnect(ConnectionFactory<?> connectionFactory, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(connectionFactory)) {
            interceptor.preConnect(connectionFactory, request);
        }
    }

    private void postConnect(ConnectionFactory<?> connectionFactory, Connection<?> connection, WebRequest request) {
        for (ConnectInterceptor<?> interceptor : this.interceptingConnectionsTo(connectionFactory)) {
            interceptor.postConnect(connection, request);
        }
    }

    private List<ConnectInterceptor<?>> interceptingConnectionsTo(ConnectionFactory<?> connectionFactory) {
        Class serviceType = GenericTypeResolver.resolveTypeArgument(connectionFactory.getClass(), ConnectionFactory.class);
        List<ConnectInterceptor<?>> typedInterceptors = (List<ConnectInterceptor<?>>)this.interceptors.get((Object)serviceType);
        if (typedInterceptors == null) {
            typedInterceptors = Collections.emptyList();
        }
        return typedInterceptors;
    }

    private void processFlash(WebRequest request, Model model) {
        DuplicateConnectionException exception = (DuplicateConnectionException)((Object)request.getAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, 1));
        if (exception != null) {
            model.addAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, (Object)Boolean.TRUE);
            request.removeAttribute(DUPLICATE_CONNECTION_ATTRIBUTE, 1);
        }
    }

    private RedirectView connectionStatusRedirect(String providerId) {
        return new RedirectView(this.getControllerPath() + "/" + providerId, true);
    }
}

