/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web;

import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuth1Version;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.GrantType;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Parameters;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectSupport {
    private boolean useAuthenticateUrl;
    private URL applicationUrl;
    private static final String OAUTH_TOKEN_ATTRIBUTE = "oauthToken";

    public void setUseAuthenticateUrl(boolean useAuthenticateUrl) {
        this.useAuthenticateUrl = useAuthenticateUrl;
    }

    public void setApplicationUrl(URL applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public String buildOAuthUrl(ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        if (connectionFactory instanceof OAuth1ConnectionFactory) {
            return this.buildOAuth1Url((OAuth1ConnectionFactory)connectionFactory, request);
        }
        if (connectionFactory instanceof OAuth2ConnectionFactory) {
            return this.buildOAuth2Url((OAuth2ConnectionFactory)connectionFactory, request);
        }
        throw new IllegalArgumentException("ConnectionFactory not supported");
    }

    public Connection<?> completeConnection(OAuth1ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        String verifier = request.getParameter("oauth_verifier");
        AuthorizedRequestToken requestToken = new AuthorizedRequestToken(this.extractCachedRequestToken((WebRequest)request), verifier);
        OAuthToken accessToken = connectionFactory.getOAuthOperations().exchangeForAccessToken(requestToken, null);
        return connectionFactory.createConnection(accessToken);
    }

    public Connection<?> completeConnection(OAuth2ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        String code = request.getParameter("code");
        AccessGrant accessGrant = connectionFactory.getOAuthOperations().exchangeForAccess(code, this.callbackUrl(request), null);
        return connectionFactory.createConnection(accessGrant);
    }

    private String buildOAuth1Url(OAuth1ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        String authorizeUrl;
        OAuthToken requestToken;
        OAuth1Operations oauthOperations = connectionFactory.getOAuthOperations();
        if (oauthOperations.getVersion() == OAuth1Version.CORE_10_REVISION_A) {
            requestToken = oauthOperations.fetchRequestToken(this.callbackUrl(request), null);
            authorizeUrl = this.buildOAuth1Url(oauthOperations, requestToken.getValue(), OAuth1Parameters.NONE);
        } else {
            requestToken = oauthOperations.fetchRequestToken(null, null);
            authorizeUrl = this.buildOAuth1Url(oauthOperations, requestToken.getValue(), new OAuth1Parameters(this.callbackUrl(request)));
        }
        request.setAttribute(OAUTH_TOKEN_ATTRIBUTE, (Object)requestToken, 1);
        return authorizeUrl;
    }

    private String buildOAuth2Url(OAuth2ConnectionFactory<?> connectionFactory, NativeWebRequest request) {
        OAuth2Operations oauthOperations = connectionFactory.getOAuthOperations();
        OAuth2Parameters parameters = new OAuth2Parameters(this.callbackUrl(request), request.getParameter("scope"));
        if (this.useAuthenticateUrl) {
            return oauthOperations.buildAuthenticateUrl(GrantType.AUTHORIZATION_CODE, parameters);
        }
        return oauthOperations.buildAuthorizeUrl(GrantType.AUTHORIZATION_CODE, parameters);
    }

    private String callbackUrl(NativeWebRequest request) {
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (this.applicationUrl != null) {
            return this.applicationUrl.getProtocol() + "://" + this.applicationUrl.getHost() + this.portPart() + nativeRequest.getRequestURI();
        }
        return nativeRequest.getRequestURL().toString();
    }

    private String portPart() {
        int port = this.applicationUrl.getPort();
        if (port == -1) {
            return "";
        }
        return ":" + port;
    }

    private String buildOAuth1Url(OAuth1Operations oauthOperations, String requestToken, OAuth1Parameters parameters) {
        if (this.useAuthenticateUrl) {
            return oauthOperations.buildAuthenticateUrl(requestToken, parameters);
        }
        return oauthOperations.buildAuthorizeUrl(requestToken, parameters);
    }

    private OAuthToken extractCachedRequestToken(WebRequest request) {
        OAuthToken requestToken = (OAuthToken)request.getAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        request.removeAttribute(OAUTH_TOKEN_ATTRIBUTE, 1);
        return requestToken;
    }
}

