/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.cmis;

import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.springframework.extensions.cmis.CMISConnection;
import org.springframework.extensions.cmis.CMISConnectionManagerImpl;
import org.springframework.extensions.cmis.CMISServer;

public class CMISConnectionImpl
implements CMISConnection {
    private CMISConnectionManagerImpl connectionManager;
    private String id;
    private String internalId;
    private Session session;
    private CMISServer server;
    private String username;
    private boolean isDefault;
    private boolean isShared;

    public CMISConnectionImpl(CMISConnectionManagerImpl connectionManager, String id, Session session, CMISServer server, String username, boolean isDefault, boolean isShared) {
        if (connectionManager == null) {
            throw new IllegalArgumentException("Connection Manager must be set!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id must be set!");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        this.connectionManager = connectionManager;
        this.internalId = id;
        this.id = id;
        this.session = session;
        this.server = server;
        this.username = username;
        this.isDefault = isDefault;
        this.isShared = isShared;
    }

    public String getId() {
        return this.id;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public Session getSession() {
        return this.session;
    }

    public CMISServer getServer() {
        return this.server;
    }

    public String getUserName() {
        return this.username;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public boolean supportsQuery() {
        if (this.session == null) {
            return false;
        }
        if (this.session.getRepositoryInfo().getCapabilities() == null) {
            return true;
        }
        return this.session.getRepositoryInfo().getCapabilities().getQueryCapability() != CapabilityQuery.NONE;
    }

    public void close() {
        this.connectionManager.removeConnection(this);
        this.session = null;
    }

    public int compareTo(CMISConnection conn) {
        return this.id.compareTo(conn.getId());
    }
}

