/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.cmis;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.extensions.cmis.CMISServer;
import org.springframework.extensions.cmis.CMISServerImpl;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISServersConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_ELEMENT_ID = "cmis-servers";
    private final Map<String, CMISServer> serverDefintions = new HashMap<String, CMISServer>();
    private Element instantiatedElement = null;

    public CMISServersConfigElement(Element element) {
        super(CONFIG_ELEMENT_ID);
        this.instantiatedElement = element;
        for (Element childElement : element.elements("server")) {
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            String name = null;
            String description = null;
            for (Element parameterElement : childElement.elements("parameter")) {
                String key = parameterElement.attributeValue("key");
                String value = parameterElement.attributeValue("value");
                if (key == null || value == null) continue;
                if (key.equals("name")) {
                    name = value;
                    continue;
                }
                if (key.equals("description")) {
                    description = value;
                    continue;
                }
                parameters.put(key, value);
            }
            if (name == null) continue;
            this.serverDefintions.put(name, new CMISServerImpl(name, description, parameters));
        }
    }

    public ConfigElement combine(ConfigElement configElement) {
        CMISServersConfigElement combinedElement = new CMISServersConfigElement(this.instantiatedElement);
        if (configElement instanceof CMISServersConfigElement) {
            combinedElement.serverDefintions.putAll(((CMISServersConfigElement)configElement).getServerDefinitions());
        }
        return combinedElement;
    }

    public Map<String, CMISServer> getServerDefinitions() {
        return this.serverDefintions;
    }
}

