/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateSource;
import freemarker.log.Logger;
import freemarker.template.utility.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;

public class WebappTemplateLoader
implements TemplateLoader {
    private static final Logger logger = Logger.getLogger("freemarker.cache");
    private final ServletContext servletContext;
    private final String path;

    public WebappTemplateLoader(ServletContext servletContext) {
        this(servletContext, "/");
    }

    public WebappTemplateLoader(ServletContext servletContext, String path) {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext == null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        this.servletContext = servletContext;
    }

    public Object findTemplateSource(String name) throws IOException {
        String fullPath;
        block6: {
            File file;
            block7: {
                fullPath = String.valueOf(this.path) + name;
                String realPath = this.servletContext.getRealPath(fullPath);
                if (realPath == null) break block6;
                file = new File(realPath);
                if (file.isFile()) break block7;
                return null;
            }
            try {
                if (file.canRead()) {
                    return file;
                }
            }
            catch (SecurityException realPath) {
                // empty catch block
            }
        }
        URL url = null;
        try {
            url = this.servletContext.getResource(fullPath);
        }
        catch (MalformedURLException e) {
            logger.warn("Could not retrieve resource " + StringUtil.jQuoteNoXSS(fullPath), e);
            return null;
        }
        return url == null ? null : new URLTemplateSource(url);
    }

    public long getLastModified(Object templateSource) {
        if (templateSource instanceof File) {
            return ((File)templateSource).lastModified();
        }
        return ((URLTemplateSource)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (templateSource instanceof File) {
            return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
        }
        return new InputStreamReader(((URLTemplateSource)templateSource).getInputStream(), encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        if (!(templateSource instanceof File)) {
            ((URLTemplateSource)templateSource).close();
        }
    }
}

