/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class ConditionalBlock
extends TemplateElement {
    final Expression condition;
    private final boolean isFirst;
    boolean isSimple;

    ConditionalBlock(Expression condition, TemplateElement nestedBlock, boolean isFirst) {
        this.condition = condition;
        this.nestedBlock = nestedBlock;
        this.isFirst = isFirst;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if ((this.condition == null || this.condition.isTrue(env)) && this.nestedBlock != null) {
            env.visit(this.nestedBlock);
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        if (this.condition == null) {
            buf.append("<#else");
        } else if (this.isFirst) {
            buf.append("<#if ");
        } else {
            buf.append("<#elseif ");
        }
        if (this.condition != null) {
            buf.append(this.condition.getCanonicalForm());
        }
        buf.append(">");
        if (this.nestedBlock != null) {
            buf.append(this.nestedBlock.getCanonicalForm());
        }
        if (this.isSimple) {
            buf.append("</#if>");
        }
        return buf.toString();
    }

    public String getDescription() {
        String s = "if ";
        if (this.condition == null) {
            s = "else ";
        } else if (!this.isFirst) {
            s = "elseif ";
        }
        String cond = this.condition != null ? this.condition.toString() : "";
        return String.valueOf(s) + cond;
    }
}

