/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class DollarVariable
extends TemplateElement {
    private final Expression expression;
    private final Expression escapedExpression;

    DollarVariable(Expression expression, Expression escapedExpression) {
        this.expression = expression;
        this.escapedExpression = escapedExpression;
    }

    void accept(Environment env) throws TemplateException, IOException {
        env.getOut().write(this.escapedExpression.getStringValue(env));
    }

    public String getCanonicalForm() {
        return "${" + this.expression.getCanonicalForm() + "}";
    }

    public String getDescription() {
        return String.valueOf(this.getSource()) + (this.expression == this.escapedExpression ? "" : " escaped ${" + this.escapedExpression.getCanonicalForm() + "}");
    }

    boolean heedsOpeningWhitespace() {
        return true;
    }

    boolean heedsTrailingWhitespace() {
        return true;
    }
}

