/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;

final class MixedContent
extends TemplateElement {
    MixedContent() {
        this.nestedElements = new ArrayList();
    }

    void addElement(TemplateElement element) {
        this.nestedElements.add(element);
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        if (this.nestedElements.size() == 1) {
            return (TemplateElement)this.nestedElements.get(0);
        }
        return this;
    }

    void accept(Environment env) throws TemplateException, IOException {
        int i = 0;
        while (i < this.nestedElements.size()) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            env.visit(element);
            ++i;
        }
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.nestedElements.size()) {
            TemplateElement element = (TemplateElement)this.nestedElements.get(i);
            buf.append(element.getCanonicalForm());
            ++i;
        }
        return buf.toString();
    }

    public String getDescription() {
        if (this.parent == null) {
            return "root element";
        }
        return "content";
    }

    boolean isIgnorable() {
        return this.nestedElements == null || this.nestedElements.size() == 0;
    }
}

