/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.utility.StringUtil;
import java.util.List;

abstract class NodeBuiltins {
    NodeBuiltins() {
    }

    static class AncestorSequence
    extends SimpleSequence
    implements TemplateMethodModel {
        private Environment env;

        AncestorSequence(Environment env) {
            this.env = env;
        }

        public Object exec(List names) throws TemplateModelException {
            if (names == null || names.isEmpty()) {
                return this;
            }
            AncestorSequence result = new AncestorSequence(this.env);
            int i = 0;
            while (i < this.size()) {
                TemplateNodeModel tnm = (TemplateNodeModel)this.get(i);
                String nodeName = tnm.getNodeName();
                String nsURI = tnm.getNodeNamespace();
                if (nsURI == null) {
                    if (names.contains(nodeName)) {
                        result.add(tnm);
                    }
                } else {
                    int j = 0;
                    while (j < names.size()) {
                        if (StringUtil.matchesName((String)names.get(j), nodeName, nsURI, this.env)) {
                            result.add(tnm);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return result;
        }
    }

    static abstract class NodeBuiltIn
    extends BuiltIn {
        NodeBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (!(model instanceof TemplateNodeModel)) {
                throw NodeBuiltIn.invalidTypeException(model, this.target, env, "node model");
            }
            return this.calculateResult((TemplateNodeModel)model, env);
        }

        abstract TemplateModel calculateResult(TemplateNodeModel var1, Environment var2) throws TemplateModelException;
    }

    static class ancestorsBI
    extends NodeBuiltIn {
        ancestorsBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            AncestorSequence result = new AncestorSequence(env);
            TemplateNodeModel parent = nodeModel.getParentNode();
            while (parent != null) {
                result.add(parent);
                parent = parent.getParentNode();
            }
            return result;
        }
    }

    static class childrenBI
    extends NodeBuiltIn {
        childrenBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getChildNodes();
        }
    }

    static class node_nameBI
    extends NodeBuiltIn {
        node_nameBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return new SimpleScalar(nodeModel.getNodeName());
        }
    }

    static class node_namespaceBI
    extends NodeBuiltIn {
        node_namespaceBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            String nsURI = nodeModel.getNodeNamespace();
            return nsURI == null ? null : new SimpleScalar(nsURI);
        }
    }

    static class node_typeBI
    extends NodeBuiltIn {
        node_typeBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return new SimpleScalar(nodeModel.getNodeType());
        }
    }

    static class parentBI
    extends NodeBuiltIn {
        parentBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            return nodeModel.getParentNode();
        }
    }

    static class rootBI
    extends NodeBuiltIn {
        rootBI() {
        }

        TemplateModel calculateResult(TemplateNodeModel nodeModel, Environment env) throws TemplateModelException {
            TemplateNodeModel result = nodeModel;
            TemplateNodeModel parent = nodeModel.getParentNode();
            while (parent != null) {
                result = parent;
                parent = result.getParentNode();
            }
            return result;
        }
    }
}

