/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.FMParserConstants;
import freemarker.core.TemplateObject;
import freemarker.core.Token;
import freemarker.template.utility.SecurityUtilities;
import java.io.IOException;

public class ParseException
extends IOException
implements FMParserConstants {
    protected boolean specialConstructor;
    public Token currentToken;
    public int columnNumber;
    public int lineNumber;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    private String templateName = "unknown template";
    protected String eol = SecurityUtilities.getSystemProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    protected ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message, int lineNumber, int columnNumber) {
        super(message);
        this.specialConstructor = false;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ParseException(String message, TemplateObject tobj) {
        super(message);
        this.specialConstructor = false;
        this.lineNumber = tobj.beginLine;
        this.columnNumber = tobj.beginColumn;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return String.valueOf(super.getMessage()) + " in " + this.templateName;
        }
        String retval = this.customGetMessage();
        if (retval != null) {
            return retval;
        }
        String expected = "";
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected = String.valueOf(expected) + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = String.valueOf(expected) + "...";
            }
            expected = String.valueOf(expected) + this.eol + "    ";
            ++i;
        }
        retval = "Encountered \"";
        Token tok = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + this.tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + this.add_escapes(tok.image);
            tok = tok.next;
            ++i2;
        }
        retval = String.valueOf(retval) + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        retval = String.valueOf(retval) + " in " + this.templateName + "." + this.eol;
        retval = this.expectedTokenSequences.length == 1 ? String.valueOf(retval) + "Was expecting:" + this.eol + "    " : String.valueOf(retval) + "Was expecting one of:" + this.eol + "    ";
        retval = String.valueOf(retval) + expected;
        return retval;
    }

    public int getLineNumber() {
        return this.currentToken != null ? this.currentToken.next.beginLine : this.lineNumber;
    }

    public int getColumnNumber() {
        return this.currentToken != null ? this.currentToken.next.beginColumn : this.columnNumber;
    }

    private String customGetMessage() {
        Token nextToken = this.currentToken.next;
        int kind = nextToken.kind;
        if (kind == 0) {
            StringBuffer buf = new StringBuffer("Unexpected end of file reached.\n");
            int i = 0;
            while (i < this.expectedTokenSequences.length) {
                int[] sequence = this.expectedTokenSequences[i];
                switch (sequence[0]) {
                    case 35: {
                        buf.append("Unclosed foreach directive.\n");
                        break;
                    }
                    case 32: {
                        buf.append("Unclosed list directive.\n");
                        break;
                    }
                    case 43: {
                        buf.append("Unclosed switch directive.\n");
                        break;
                    }
                    case 31: {
                        buf.append("Unclosed if directive.\n");
                        break;
                    }
                    case 41: {
                        buf.append("Unclosed compress directive.\n");
                        break;
                    }
                    case 40: {
                        buf.append("Unclosed macro directive.\n");
                        break;
                    }
                    case 39: {
                        buf.append("Unclosed function directive.\n");
                        break;
                    }
                    case 42: {
                        buf.append("Unclosed transform directive.\n");
                        break;
                    }
                    case 60: {
                        buf.append("Unclosed escape directive.\n");
                        break;
                    }
                    case 62: {
                        buf.append("Unclosed noescape directive.\n");
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        if (kind == 31 || kind == 9 || kind == 44) {
            return "Found unexpected directive: " + nextToken + " on line " + nextToken.beginLine + ", column " + nextToken.beginColumn + "\nCheck whether you have a well-formed if-else block.";
        }
        return null;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

