/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ListLiteral;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;

final class RecurseNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    RecurseNode(Expression targetNode, Expression namespaces) {
        this.targetNode = targetNode;
        this.namespaces = namespaces;
    }

    void accept(Environment env) throws IOException, TemplateException {
        TemplateModel nss;
        TemplateModel node = this.targetNode == null ? null : this.targetNode.getAsTemplateModel(env);
        TemplateModel templateModel = nss = this.namespaces == null ? null : this.namespaces.getAsTemplateModel(env);
        if (this.namespaces instanceof StringLiteral) {
            nss = env.importLib(((TemplateScalarModel)nss).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(env);
        }
        if (node != null && !(node instanceof TemplateNodeModel)) {
            throw new TemplateException("Expecting an XML node here, for expression: " + this.targetNode + ", found a: " + node.getClass().getName(), env);
        }
        if (nss != null) {
            if (nss instanceof TemplateHashModel) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(nss);
                nss = ss;
            } else if (!(nss instanceof TemplateSequenceModel)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", env);
            }
        }
        env.recurse((TemplateNodeModel)node, (TemplateSequenceModel)nss);
    }

    public String getCanonicalForm() {
        String result = "<#recurse";
        if (this.targetNode != null) {
            result = String.valueOf(result) + " " + this.targetNode.getCanonicalForm();
        }
        if (this.namespaces != null) {
            result = String.valueOf(result) + " using " + this.namespaces.getCanonicalForm();
        }
        return String.valueOf(result) + "/>";
    }

    public String getDescription() {
        return "recurse instruction";
    }
}

