/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.ObjectConstructor;

public interface TemplateClassResolver {
    public static final TemplateClassResolver UNRESTRICTED_RESOLVER = new TemplateClassResolver(){

        public Class resolve(String className, Environment env, Template template) throws TemplateException {
            try {
                return ClassUtil.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new TemplateException(e, env);
            }
        }
    };
    public static final TemplateClassResolver SAFER_RESOLVER = new TemplateClassResolver(){

        public Class resolve(String className, Environment env, Template template) throws TemplateException {
            if (className.equals(ObjectConstructor.class.getName())) {
                throw new TemplateException("Instantiating " + className + " is not allowed in the " + "template for security reasons.", env);
            }
            try {
                return ClassUtil.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new TemplateException(e, env);
            }
        }
    };
    public static final TemplateClassResolver ALLOWS_NOTHING_RESOLVER = new TemplateClassResolver(){

        public Class resolve(String className, Environment env, Template template) throws TemplateException {
            throw new TemplateException("Instantiating " + className + " is not allowed in the " + "template for security reasons.", env);
        }
    };

    public Class resolve(String var1, Environment var2, Template var3) throws TemplateException;
}

