/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.NonNumericalException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class UnaryPlusMinusExpression
extends Expression {
    private final Expression target;
    private final boolean isMinus;
    private static final Integer MINUS_ONE = new Integer(-1);

    UnaryPlusMinusExpression(Expression target, boolean isMinus) {
        this.target = target;
        this.isMinus = isMinus;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateNumberModel targetModel = null;
        try {
            targetModel = (TemplateNumberModel)this.target.getAsTemplateModel(env);
        }
        catch (ClassCastException cce) {
            String msg = "Error " + this.getStartLocation();
            msg = String.valueOf(msg) + "\nExpression " + this.target + " is not numerical.";
            throw new NonNumericalException(msg, env);
        }
        if (!this.isMinus) {
            return targetModel;
        }
        Number n = targetModel.getAsNumber();
        n = ArithmeticEngine.CONSERVATIVE_ENGINE.multiply(MINUS_ONE, n);
        return new SimpleNumber(n);
    }

    public String getCanonicalForm() {
        String op = this.isMinus ? "-" : "+";
        return String.valueOf(op) + this.target.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.target.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new UnaryPlusMinusExpression(this.target.deepClone(name, subst), this.isMinus);
    }
}

