/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassString;
import freemarker.ext.beans.MethodUtilities;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class OverloadedMethod {
    static final Object NO_SUCH_METHOD = new Object();
    static final Object AMBIGUOUS_METHOD = new Object();
    static final Object[] EMPTY_ARGS = new Object[0];
    private Class[][] marshalTypes;
    private final Map selectorCache = new HashMap();
    private final List members = new LinkedList();
    private final Map signatures = new HashMap();

    OverloadedMethod() {
    }

    void addMember(Member member) {
        this.members.add(member);
        Class[] argTypes = MethodUtilities.getParameterTypes(member);
        int l = argTypes.length;
        this.signatures.put(member, argTypes.clone());
        this.onAddSignature(member, argTypes);
        if (this.marshalTypes == null) {
            this.marshalTypes = new Class[l + 1][];
            this.marshalTypes[l] = argTypes;
            this.updateSignature(l);
        } else if (this.marshalTypes.length <= l) {
            Class[][] newMarshalTypes = new Class[l + 1][];
            System.arraycopy(this.marshalTypes, 0, newMarshalTypes, 0, this.marshalTypes.length);
            this.marshalTypes = newMarshalTypes;
            this.marshalTypes[l] = argTypes;
            this.updateSignature(l);
        } else {
            Class[] oldTypes = this.marshalTypes[l];
            if (oldTypes == null) {
                this.marshalTypes[l] = argTypes;
            } else {
                int i = 0;
                while (i < oldTypes.length) {
                    oldTypes[i] = MethodUtilities.getMostSpecificCommonType(oldTypes[i], argTypes[i]);
                    ++i;
                }
            }
            this.updateSignature(l);
        }
        this.afterSignatureAdded(l);
    }

    Class[] getSignature(Member member) {
        return (Class[])this.signatures.get(member);
    }

    Class[][] getMarshalTypes() {
        return this.marshalTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getMemberForArgs(Object[] args, boolean varArg) {
        Object objMember;
        ClassString argTypes = new ClassString(args);
        Map map = this.selectorCache;
        synchronized (map) {
            objMember = this.selectorCache.get(argTypes);
            if (objMember == null) {
                objMember = argTypes.getMostSpecific(this.members, varArg);
                this.selectorCache.put(argTypes, objMember);
            }
        }
        return objMember;
    }

    abstract void onAddSignature(Member var1, Class[] var2);

    abstract void updateSignature(int var1);

    abstract void afterSignatureAdded(int var1);

    abstract Object getMemberAndArguments(List var1, BeansWrapper var2) throws TemplateModelException;
}

