/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MethodUtilities;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class SimpleMemberModel {
    private final Member member;
    private final Class[] argTypes;

    protected SimpleMemberModel(Member member, Class[] argTypes) {
        this.member = member;
        this.argTypes = argTypes;
    }

    Object[] unwrapArguments(List arguments, BeansWrapper wrapper) throws TemplateModelException {
        Object[] args;
        if (arguments == null) {
            arguments = Collections.EMPTY_LIST;
        }
        boolean varArg = MethodUtilities.isVarArgs(this.member);
        int typeLen = this.argTypes.length;
        if (varArg) {
            if (typeLen - 1 > arguments.size()) {
                throw new TemplateModelException("Method " + this.member + " takes at least " + (typeLen - 1) + " arguments");
            }
        } else if (typeLen != arguments.size()) {
            throw new TemplateModelException("Method " + this.member + " takes exactly " + typeLen + " arguments");
        }
        if ((args = SimpleMemberModel.unwrapArguments(arguments, this.argTypes, wrapper)) != null) {
            BeansWrapper.coerceBigDecimals(this.argTypes, args);
            if (varArg && this.shouldPackVarArgs(args)) {
                args = SimpleMemberModel.packVarArgs(args, this.argTypes);
            }
        }
        return args;
    }

    static Object[] unwrapArguments(List arguments, Class[] argTypes, BeansWrapper w) throws TemplateModelException {
        if (arguments == null) {
            return null;
        }
        int argsLen = arguments.size();
        int typeLen = argTypes.length;
        Object[] args = new Object[argsLen];
        int min = Math.min(argsLen, typeLen);
        Iterator it = arguments.iterator();
        int i = 0;
        while (i < min) {
            args[i] = SimpleMemberModel.unwrapArgument((TemplateModel)it.next(), argTypes[i], w);
            ++i;
        }
        i = min;
        while (i < argsLen) {
            args[i] = SimpleMemberModel.unwrapArgument((TemplateModel)it.next(), argTypes[min - 1], w);
            ++i;
        }
        return args;
    }

    private static Object unwrapArgument(TemplateModel model, Class type, BeansWrapper w) throws TemplateModelException {
        Object val = w.unwrapInternal(model, type);
        if (val == BeansWrapper.CAN_NOT_UNWRAP) {
            throw new TemplateModelException("Can not unwrap argument " + model + " to " + type.getName());
        }
        return val;
    }

    private boolean shouldPackVarArgs(Object[] args) {
        Object lastArg;
        int l = args.length;
        return l != this.argTypes.length || (lastArg = args[l - 1]) != null && !this.argTypes[l - 1].getComponentType().isInstance(lastArg);
    }

    static Object[] packVarArgs(Object[] args, Class[] argTypes) {
        int argsLen = args.length;
        int typeLen = argTypes.length;
        int fixArgsLen = typeLen - 1;
        Object varArray = Array.newInstance(argTypes[fixArgsLen], argsLen - fixArgsLen);
        int i = fixArgsLen;
        while (i < argsLen) {
            Array.set(varArray, i - fixArgsLen, args[i]);
            ++i;
        }
        if (argsLen != typeLen) {
            Object[] newArgs = new Object[typeLen];
            System.arraycopy(args, 0, newArgs, 0, fixArgsLen);
            args = newArgs;
        }
        args[fixArgsLen] = varArray;
        return args;
    }

    protected Member getMember() {
        return this.member;
    }
}

