/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.dom;

import freemarker.core.Environment;
import freemarker.ext.dom.NodeListModel;
import freemarker.ext.dom.XPathSupport;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNull;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

class XalanXPathSupport
implements XPathSupport {
    private XPathContext xpathContext = new XPathContext();
    private static final String ERRMSG_EMPTY_NODE_SET = "Cannot perform an XPath query against an empty node set.";
    private static PrefixResolver customPrefixResolver = new PrefixResolver(){

        public String getNamespaceForPrefix(String prefix, Node node) {
            return this.getNamespaceForPrefix(prefix);
        }

        public String getNamespaceForPrefix(String prefix) {
            if (prefix.equals("D")) {
                return Environment.getCurrentEnvironment().getDefaultNS();
            }
            return Environment.getCurrentEnvironment().getNamespaceForPrefix(prefix);
        }

        public String getBaseIdentifier() {
            return null;
        }

        public boolean handlesNullPrefixes() {
            return false;
        }
    };

    XalanXPathSupport() {
    }

    public synchronized TemplateModel executeQuery(Object context, String xpathQuery) throws TemplateModelException {
        XObject xresult;
        block12: {
            if (!(context instanceof Node)) {
                if (context != null) {
                    if (XalanXPathSupport.isNodeList(context)) {
                        int cnt = ((List)context).size();
                        if (cnt != 0) {
                            throw new TemplateModelException("Cannot perform an XPath query against a node set of " + cnt + " nodes. Expecting a single node.");
                        }
                        throw new TemplateModelException(ERRMSG_EMPTY_NODE_SET);
                    }
                    throw new TemplateModelException("Cannot perform an XPath query against a " + context.getClass().getName() + ". Expecting a single org.w3c.dom.Node.");
                }
                throw new TemplateModelException(ERRMSG_EMPTY_NODE_SET);
            }
            Node node = (Node)context;
            try {
                XPath xpath = new XPath(xpathQuery, null, customPrefixResolver, 0, null);
                int ctxtNode = this.xpathContext.getDTMHandleFromNode(node);
                xresult = xpath.execute(this.xpathContext, ctxtNode, customPrefixResolver);
                if (xresult instanceof XNodeSet) {
                    Node n;
                    NodeListModel result = new NodeListModel(node);
                    result.xpathSupport = this;
                    NodeIterator nodeIterator = xresult.nodeset();
                    do {
                        if ((n = nodeIterator.nextNode()) == null) continue;
                        result.add(n);
                    } while (n != null);
                    return result.size() == 1 ? result.get(0) : result;
                }
                if (xresult instanceof XBoolean) {
                    return ((XBoolean)xresult).bool() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                }
                if (!(xresult instanceof XNull)) break block12;
                return null;
            }
            catch (TransformerException te) {
                throw new TemplateModelException(te);
            }
        }
        if (xresult instanceof XString) {
            return new SimpleScalar(xresult.toString());
        }
        if (xresult instanceof XNumber) {
            return new SimpleNumber(new Double(((XNumber)xresult).num()));
        }
        throw new TemplateModelException("Cannot deal with type: " + xresult.getClass().getName());
    }

    private static boolean isNodeList(Object context) {
        if (context instanceof List) {
            List ls = (List)context;
            int ln = ls.size();
            int i = 0;
            while (i < ln) {
                if (!(ls.get(i) instanceof Node)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

