/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.template.utility.DateUtil;
import freemarker.template.utility.UnrecognizedTimeZoneException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;

public class DateUtilTest
extends TestCase {
    private static final DateFormat DF = new SimpleDateFormat("G yyyy-MM-dd HH:mm:ss:S Z", Locale.US);
    private DateUtil.DateToISO8601CalendarFactory calendarFactory = new DateUtil.TrivialDateToISO8601CalendarFactory();

    static {
        DF.setTimeZone(DateUtil.UTC);
    }

    public DateUtilTest(String name) {
        super(name);
    }

    public void testDateToUTCString() throws ParseException {
        DateUtilTest.assertEquals((Object)"1998-10-30T15:30:00.512Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 1998-10-30 19:30:00:512 +0400"), true));
        DateUtilTest.assertEquals((Object)"1998-10-30T15:30:00.5Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 1998-10-30 19:30:00:500 +0400"), true));
        DateUtilTest.assertEquals((Object)"1998-10-30T15:30:00.51Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 1998-10-30 19:30:00:510 +0400"), true));
        DateUtilTest.assertEquals((Object)"1998-10-30T15:30:00.1Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 1998-10-30 19:30:00:100 +0400"), true));
        DateUtilTest.assertEquals((Object)"1998-10-30T15:30:00.01Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 1998-10-30 19:30:00:10 +0400"), true));
        DateUtilTest.assertEquals((Object)"1998-10-30T15:30:00.001Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 1998-10-30 19:30:00:1 +0400"), true));
        DateUtilTest.assertEquals((Object)"2000-02-08T06:05:04Z", (Object)this.dateToISO8601UTCDateTimeMSString(DF.parse("AD 2000-02-08 09:05:04:0 +0300"), true));
        DateUtilTest.assertEquals((Object)"0100-02-28T06:15:24Z", (Object)this.dateToISO8601UTCDateTimeString(DF.parse("AD 0100-02-28 09:15:24:0 +0300"), true));
        DateUtilTest.assertEquals((Object)"0010-02-28T06:15:24Z", (Object)this.dateToISO8601UTCDateTimeString(DF.parse("AD 0010-02-28 09:15:24:0 +0300"), true));
        DateUtilTest.assertEquals((Object)"0001-02-28T06:15:24Z", (Object)this.dateToISO8601UTCDateTimeString(DF.parse("AD 0001-02-28 09:15:24:0 +0300"), true));
        DateUtilTest.assertEquals((Object)"0000-02-28T06:15:24Z", (Object)this.dateToISO8601UTCDateTimeString(DF.parse("BC 0001-02-28 09:15:24:0 +0300"), true));
        DateUtilTest.assertEquals((Object)"-1-02-28T06:15:24Z", (Object)this.dateToISO8601UTCDateTimeString(DF.parse("BC 2-02-28 09:15:24:0 +0300"), true));
        DateUtilTest.assertEquals((Object)"10000-02-28T06:15:24Z", (Object)this.dateToISO8601UTCDateTimeString(DF.parse("AD 10000-02-28 09:15:24:0 +0300"), true));
        Date d = DF.parse("AD 1998-10-30 19:30:00:512 +0400");
        DateUtilTest.assertEquals((Object)"1998-10-30", (Object)this.dateToISO8601UTCDateString(d));
        DateUtilTest.assertEquals((Object)"15:30:00.512Z", (Object)this.dateToISO8601UTCTimeMSString(d, true));
        DateUtilTest.assertEquals((Object)"15:30:00.512", (Object)this.dateToISO8601UTCTimeMSString(d, false));
        DateUtilTest.assertEquals((Object)"1998-10-30", (Object)this.dateToISO8601UTCDateString(new java.sql.Date(d.getTime())));
        DateUtilTest.assertEquals((Object)"15:30:00.512Z", (Object)this.dateToISO8601UTCTimeMSString(new Time(d.getTime()), true));
    }

    public void testLocalTime() throws ParseException {
        Date dsum = DF.parse("AD 2010-05-09 20:00:00:0 UTC");
        Date dwin = DF.parse("AD 2010-01-01 20:00:00:0 UTC");
        TimeZone tzRome = TimeZone.getTimeZone("Europe/Rome");
        if (tzRome.getOffset(0L) == 0) {
            throw new RuntimeException("Can't get time zone for Europe/Rome!");
        }
        DateUtilTest.assertEquals((Object)"2010-05-09T22:00:00+02", (Object)this.dateToISO8601DateTimeString(dsum, tzRome));
        DateUtilTest.assertEquals((Object)"2010-01-01T21:00:00+01", (Object)this.dateToISO8601DateTimeString(dwin, tzRome));
        DateUtilTest.assertEquals((Object)"2010-05-09", (Object)this.dateToISO8601DateString(dsum, tzRome));
        DateUtilTest.assertEquals((Object)"2010-01-01", (Object)this.dateToISO8601DateString(dwin, tzRome));
        DateUtilTest.assertEquals((Object)"22:00:00+02", (Object)this.dateToISO8601TimeString(dsum, tzRome));
        DateUtilTest.assertEquals((Object)"21:00:00+01", (Object)this.dateToISO8601TimeString(dwin, tzRome));
        TimeZone tzNY = TimeZone.getTimeZone("America/New_York");
        if (tzNY.getOffset(0L) == 0) {
            throw new RuntimeException("Can't get time zone for America/New_York!");
        }
        DateUtilTest.assertEquals((Object)"2010-05-09T16:00:00-04", (Object)this.dateToISO8601DateTimeString(dsum, tzNY));
        DateUtilTest.assertEquals((Object)"2010-01-01T15:00:00-05", (Object)this.dateToISO8601DateTimeString(dwin, tzNY));
        DateUtilTest.assertEquals((Object)"2010-05-09", (Object)this.dateToISO8601DateString(dsum, tzNY));
        DateUtilTest.assertEquals((Object)"2010-01-01", (Object)this.dateToISO8601DateString(dwin, tzNY));
        DateUtilTest.assertEquals((Object)"16:00:00-04", (Object)this.dateToISO8601TimeString(dsum, tzNY));
        DateUtilTest.assertEquals((Object)"15:00:00-05", (Object)this.dateToISO8601TimeString(dwin, tzNY));
        TimeZone tzFixed = TimeZone.getTimeZone("GMT+02:30");
        DateUtilTest.assertEquals((Object)"2010-05-09T22:30:00+02:30", (Object)this.dateToISO8601DateTimeString(dsum, tzFixed));
        DateUtilTest.assertEquals((Object)"2010-01-01T22:30:00+02:30", (Object)this.dateToISO8601DateTimeString(dwin, tzFixed));
    }

    public void testGetTimeZone() throws Exception {
        DateUtilTest.assertTrue((DateUtil.getTimeZone("GMT") != DateUtil.UTC ? 1 : 0) != 0);
        DateUtilTest.assertTrue((DateUtil.getTimeZone("UT1") != DateUtil.UTC ? 1 : 0) != 0);
        DateUtilTest.assertEquals((Object)DateUtil.getTimeZone("UTC"), (Object)DateUtil.UTC);
        DateUtilTest.assertEquals((Object)DateUtil.getTimeZone("Europe/Rome"), (Object)TimeZone.getTimeZone("Europe/Rome"));
        DateUtilTest.assertEquals((Object)DateUtil.getTimeZone("Iceland"), (Object)TimeZone.getTimeZone("Iceland"));
        try {
            DateUtil.getTimeZone("Europe/NoSuch");
            DateUtilTest.fail();
        }
        catch (UnrecognizedTimeZoneException unrecognizedTimeZoneException) {
            // empty catch block
        }
    }

    public void testTimeOnlyDate() throws UnrecognizedTimeZoneException {
        Date t = new Date(0L);
        SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
        tf.setTimeZone(DateUtil.UTC);
        DateUtilTest.assertEquals((Object)"00:00:00", (Object)tf.format(t));
        DateUtilTest.assertEquals((Object)"00:00:00", (Object)this.dateToISO8601UTCTimeString(t, false));
        TimeZone gmt1 = DateUtil.getTimeZone("GMT+01");
        tf.setTimeZone(gmt1);
        DateUtilTest.assertEquals((Object)"01:00:00", (Object)tf.format(t));
        DateUtilTest.assertEquals((Object)"01:00:00+01", (Object)this.dateToISO8601TimeString(t, gmt1));
    }

    public void testAccuracy() throws ParseException {
        Date d = DF.parse("AD 2000-02-08 09:05:04:250 UTC");
        DateUtilTest.assertEquals((Object)"2000-02-08T09:05:04Z", (Object)this.dateToISO8601UTCDateTimeString(d, true));
        DateUtilTest.assertEquals((Object)"2000-02-08T09:05:04.25Z", (Object)this.dateToISO8601String(d, true, true, true, 7, null));
        DateUtilTest.assertEquals((Object)"2000-02-08T09:05:04Z", (Object)this.dateToISO8601String(d, true, true, true, 6, null));
        DateUtilTest.assertEquals((Object)"2000-02-08T09:05Z", (Object)this.dateToISO8601String(d, true, true, true, 5, null));
        DateUtilTest.assertEquals((Object)"2000-02-08T09Z", (Object)this.dateToISO8601String(d, true, true, true, 4, null));
    }

    private String dateToISO8601DateTimeString(Date date, TimeZone tz) {
        return this.dateToISO8601String(date, true, true, true, 6, tz);
    }

    private String dateToISO8601UTCDateTimeString(Date date, boolean offsetPart) {
        return this.dateToISO8601String(date, true, true, offsetPart, 6, DateUtil.UTC);
    }

    private String dateToISO8601UTCDateTimeMSString(Date date, boolean offsetPart) {
        return this.dateToISO8601String(date, true, true, offsetPart, 7, DateUtil.UTC);
    }

    private String dateToISO8601DateString(Date date, TimeZone tz) {
        return this.dateToISO8601String(date, true, false, false, 6, tz);
    }

    private String dateToISO8601UTCDateString(Date date) {
        return this.dateToISO8601String(date, true, false, false, 6, DateUtil.UTC);
    }

    private String dateToISO8601TimeString(Date date, TimeZone tz) {
        return this.dateToISO8601String(date, false, true, true, 6, tz);
    }

    private String dateToISO8601UTCTimeString(Date date, boolean offsetPart) {
        return this.dateToISO8601String(date, false, true, offsetPart, 6, DateUtil.UTC);
    }

    private String dateToISO8601UTCTimeMSString(Date date, boolean offsetPart) {
        return this.dateToISO8601String(date, false, true, offsetPart, 7, DateUtil.UTC);
    }

    private String dateToISO8601String(Date date, boolean datePart, boolean timePart, boolean offsetPart, int accuracy, TimeZone timeZone) {
        return DateUtil.dateToISO8601String(date, datePart, timePart, offsetPart, accuracy, timeZone, this.calendarFactory);
    }
}

