/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.core.OptInTemplateClassResolver;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.utility.ObjectConstructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class OptInTemplateClassResolverTest
extends TestCase {
    private static final Set ALLOWED_CLASSES = new HashSet();
    private static final List TRUSTED_TEMPLATES;
    private OptInTemplateClassResolver resolver = new OptInTemplateClassResolver(ALLOWED_CLASSES, TRUSTED_TEMPLATES);
    private Configuration dummyCfg = new Configuration();
    private Template dummyTemp = Template.getPlainTextTemplate("foo.ftl", "", this.dummyCfg);

    static {
        ALLOWED_CLASSES.add("java.lang.String");
        ALLOWED_CLASSES.add("java.lang.Integer");
        TRUSTED_TEMPLATES = new ArrayList();
        TRUSTED_TEMPLATES.add("lib/*");
        TRUSTED_TEMPLATES.add("/include/*");
        TRUSTED_TEMPLATES.add("trusted.ftl");
    }

    public OptInTemplateClassResolverTest(String name) {
        super(name);
    }

    public void testOptIn() throws TemplateException {
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)this.resolver.resolve("java.lang.String", null, this.dummyTemp));
        OptInTemplateClassResolverTest.assertEquals(Integer.class, (Object)this.resolver.resolve("java.lang.Integer", null, this.dummyTemp));
        try {
            this.resolver.resolve("java.lang.Long", null, this.dummyTemp);
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
    }

    public void testTrusted() throws TemplateException {
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)this.resolver.resolve("java.lang.Long", null, Template.getPlainTextTemplate("lib/foo.ftl", "", this.dummyCfg)));
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)this.resolver.resolve("java.lang.String", null, Template.getPlainTextTemplate("lib/foo.ftl", "", this.dummyCfg)));
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)this.resolver.resolve("java.lang.Long", null, Template.getPlainTextTemplate("/lib/foo.ftl", "", this.dummyCfg)));
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)this.resolver.resolve("java.lang.Long", null, Template.getPlainTextTemplate("include/foo.ftl", "", this.dummyCfg)));
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)this.resolver.resolve("java.lang.Long", null, Template.getPlainTextTemplate("trusted.ftl", "", this.dummyCfg)));
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)this.resolver.resolve("java.lang.Long", null, Template.getPlainTextTemplate("/trusted.ftl", "", this.dummyCfg)));
        try {
            OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)this.resolver.resolve(ObjectConstructor.class.getName(), null, Template.getPlainTextTemplate("trusted.ftl", "", this.dummyCfg)));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
    }

    public void testCraftedTrusted() throws TemplateException {
        this.testTrusted_checkFails("lib/../foo.ftl");
        this.testTrusted_checkFails("lib\\..\\foo.ftl");
        this.testTrusted_checkFails("lib\\../foo.ftl");
        this.testTrusted_checkFails("lib/..\\foo.ftl");
        this.testTrusted_checkFails("lib/..");
        this.testTrusted_checkFails("lib%2f%2E%2e%5cfoo.ftl");
        this.testTrusted_checkFails("/lib%5C%.%2e%2Efoo.ftl");
        try {
            this.testTrusted_checkFails("lib/./foo.ftl");
            OptInTemplateClassResolverTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            this.testTrusted_checkFails("lib/foo..ftl");
            OptInTemplateClassResolverTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            this.testTrusted_checkFails("lib/%2e/foo.ftl");
            OptInTemplateClassResolverTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testTrusted_checkFails(String templateName) {
        try {
            this.resolver.resolve("java.lang.Long", null, Template.getPlainTextTemplate(templateName, "", this.dummyCfg));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
    }

    public void testSettingParser() throws TemplateException {
        Configuration cfg = new Configuration();
        cfg.setSetting("new_builtin_class_resolver", "trusted_templates: foo.ftl, \"lib/*\"");
        TemplateClassResolver res = cfg.getNewBuiltinClassResolver();
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)res.resolve("java.lang.String", null, Template.getPlainTextTemplate("foo.ftl", "", cfg)));
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)res.resolve("java.lang.String", null, Template.getPlainTextTemplate("lib/bar.ftl", "", cfg)));
        try {
            res.resolve("java.lang.String", null, Template.getPlainTextTemplate("bar.ftl", "", cfg));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        cfg.setSetting("new_builtin_class_resolver", "allowed_classes: java.lang.String, java.lang.Integer");
        res = cfg.getNewBuiltinClassResolver();
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)res.resolve("java.lang.String", null, Template.getPlainTextTemplate("foo.ftl", "", cfg)));
        OptInTemplateClassResolverTest.assertEquals(Integer.class, (Object)res.resolve("java.lang.Integer", null, Template.getPlainTextTemplate("foo.ftl", "", cfg)));
        try {
            res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("foo.ftl", "", cfg));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        cfg.setSetting("new_builtin_class_resolver", "trusted_templates: foo.ftl, 'lib/*', allowed_classes: 'java.lang.String', java.lang.Integer");
        res = cfg.getNewBuiltinClassResolver();
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)res.resolve("java.lang.String", null, Template.getPlainTextTemplate("x.ftl", "", cfg)));
        OptInTemplateClassResolverTest.assertEquals(Integer.class, (Object)res.resolve("java.lang.Integer", null, Template.getPlainTextTemplate("x.ftl", "", cfg)));
        try {
            res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("x.ftl", "", cfg));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("foo.ftl", "", cfg)));
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("lib/bar.ftl", "", cfg)));
        try {
            res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("x.ftl", "", cfg));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        try {
            cfg.setSetting("new_builtin_class_resolver", "wrong: foo");
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        cfg.setSetting("new_builtin_class_resolver", "\"allowed_classes\"  :  java.lang.String  ,  'trusted_templates' :\"lib:*\"");
        res = cfg.getNewBuiltinClassResolver();
        OptInTemplateClassResolverTest.assertEquals(String.class, (Object)res.resolve("java.lang.String", null, Template.getPlainTextTemplate("x.ftl", "", cfg)));
        try {
            res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("x.ftl", "", cfg));
            OptInTemplateClassResolverTest.fail();
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        OptInTemplateClassResolverTest.assertEquals(Long.class, (Object)res.resolve("java.lang.Long", null, Template.getPlainTextTemplate("lib:bar.ftl", "", cfg)));
    }
}

