/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;

public class PerformanceTest {
    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        config.setClassicCompatible(false);
        config.setClassForTemplateLoading(PerformanceTest.class, "/freemarker/testcase");
        Template template = config.getTemplate("PerformanceTest.fm");
        boolean toFile = args.length > 0 && args[0].equals("file");
        File f = File.createTempFile("fmPerfTest", ".txt");
        f.deleteOnExit();
        NullStream nullStream = new NullStream();
        SimpleHash h = new SimpleHash();
        h.put("ii", new TestSequence());
        h.put("j", new TestHash());
        h.put("k", new TestMethod());
        while (true) {
            OutputStream stream = toFile ? new BufferedOutputStream(new FileOutputStream(f)) : nullStream;
            OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
            try {
                template.process(h, writer);
                continue;
            }
            finally {
                ((Writer)writer).close();
                continue;
            }
            break;
        }
    }

    private static class NullStream
    extends OutputStream {
        private NullStream() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] arg0, int arg1, int arg2) {
        }

        public void write(byte[] arg0) {
        }

        public void write(int arg0) {
        }
    }

    private static class TestHash
    implements TemplateHashModel,
    TemplateScalarModel {
        private TestHash() {
        }

        public TemplateModel get(String key) {
            return this;
        }

        public String getAsString() {
            return "j";
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private static class TestI
    implements TemplateHashModel,
    TemplateNumberModel {
        private final int i;

        TestI(int i) {
            this.i = i;
        }

        public TemplateModel get(String key) {
            return (this.i & 1) == 1 ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }

        public String getAsString(Locale locale) {
            return Integer.toString(this.i);
        }

        public Number getAsNumber() {
            return new Integer(this.i);
        }

        public boolean isEmpty() {
            return false;
        }
    }

    private static class TestMethod
    implements TemplateMethodModelEx {
        private TestMethod() {
        }

        public Object exec(List arguments) {
            return arguments.get(0);
        }
    }

    private static class TestSequence
    implements TemplateCollectionModel {
        private TestSequence() {
        }

        public TemplateModelIterator iterator() {
            return new TemplateModelIterator(){
                private int i = 0;

                public TemplateModel next() {
                    return new TestI(this.i++);
                }

                public boolean hasNext() {
                    return this.i < 1000;
                }
            };
        }
    }
}

