/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.template.utility.StringUtil;
import junit.framework.TestCase;

public class StringUtilTest
extends TestCase {
    public StringUtilTest(String name) {
        super(name);
    }

    public void testJQuote() {
        StringUtilTest.assertEquals((Object)"null", (Object)StringUtil.jQuote(null));
        StringUtilTest.assertEquals((Object)"\"foo\"", (Object)StringUtil.jQuote("foo"));
        StringUtilTest.assertEquals((Object)"\"123\"", (Object)StringUtil.jQuote(123));
        StringUtilTest.assertEquals((Object)"\"foo's \\\"bar\\\"\"", (Object)StringUtil.jQuote("foo's \"bar\""));
        StringUtilTest.assertEquals((Object)"\"\\n\\r\\t\\u0001\"", (Object)StringUtil.jQuote("\n\r\t\u0001"));
        StringUtilTest.assertEquals((Object)"\"<\\nb\\rc\\td\\u0001>\"", (Object)StringUtil.jQuote("<\nb\rc\td\u0001>"));
    }

    public void testJQuoteNoXSS() {
        StringUtilTest.assertEquals((Object)"null", (Object)StringUtil.jQuoteNoXSS(null));
        StringUtilTest.assertEquals((Object)"\"foo\"", (Object)StringUtil.jQuoteNoXSS("foo"));
        StringUtilTest.assertEquals((Object)"\"123\"", (Object)StringUtil.jQuoteNoXSS(123));
        StringUtilTest.assertEquals((Object)"\"foo's \\\"bar\\\"\"", (Object)StringUtil.jQuoteNoXSS("foo's \"bar\""));
        StringUtilTest.assertEquals((Object)"\"\\n\\r\\t\\u0001\"", (Object)StringUtil.jQuoteNoXSS("\n\r\t\u0001"));
        StringUtilTest.assertEquals((Object)"\"\\u003C\\nb\\rc\\td\\u0001>\"", (Object)StringUtil.jQuoteNoXSS("<\nb\rc\td\u0001>"));
        StringUtilTest.assertEquals((Object)"\"\\u003C\\nb\\rc\\td\\u0001>\"", (Object)StringUtil.jQuoteNoXSS((Object)"<\nb\rc\td\u0001>"));
    }
}

