/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.cache.StrongCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import junit.framework.TestCase;

public class TemplateCacheTest
extends TestCase {
    public TemplateCacheTest(String name) {
        super(name);
    }

    public void testCachedException() throws Exception {
        MockTemplateLoader loader = new MockTemplateLoader();
        TemplateCache cache = new TemplateCache(loader, new StrongCacheStorage());
        cache.setDelay(1000L);
        loader.setThrowException(true);
        try {
            cache.getTemplate("t", Locale.getDefault(), "", true);
            TemplateCacheTest.fail();
        }
        catch (IOException e) {
            TemplateCacheTest.assertEquals((Object)"mock IO exception", (Object)e.getMessage());
            TemplateCacheTest.assertEquals((int)1, (int)loader.getFindCount());
            try {
                cache.getTemplate("t", Locale.getDefault(), "", true);
                TemplateCacheTest.fail();
            }
            catch (IOException e2) {
                TemplateCacheTest.assertEquals((Object)"There was an error loading the template on an earlier attempt; it is attached as a cause", (Object)e2.getMessage());
                TemplateCacheTest.assertSame((Object)e, (Object)e2.getCause());
                TemplateCacheTest.assertEquals((int)1, (int)loader.getFindCount());
                try {
                    Thread.sleep(1100L);
                    cache.getTemplate("t", Locale.getDefault(), "", true);
                    TemplateCacheTest.fail();
                }
                catch (IOException e3) {
                    TemplateCacheTest.assertEquals((Object)"mock IO exception", (Object)e.getMessage());
                    TemplateCacheTest.assertEquals((int)2, (int)loader.getFindCount());
                }
            }
        }
    }

    public void testCachedNotFound() throws Exception {
        MockTemplateLoader loader = new MockTemplateLoader();
        TemplateCache cache = new TemplateCache(loader, new StrongCacheStorage());
        cache.setDelay(1000L);
        cache.setLocalizedLookup(false);
        TemplateCacheTest.assertNull((Object)cache.getTemplate("t", Locale.getDefault(), "", true));
        TemplateCacheTest.assertEquals((int)1, (int)loader.getFindCount());
        TemplateCacheTest.assertNull((Object)cache.getTemplate("t", Locale.getDefault(), "", true));
        TemplateCacheTest.assertEquals((int)1, (int)loader.getFindCount());
        Thread.sleep(1100L);
        TemplateCacheTest.assertNull((Object)cache.getTemplate("t", Locale.getDefault(), "", true));
        TemplateCacheTest.assertEquals((int)2, (int)loader.getFindCount());
    }

    private static class MockTemplateLoader
    implements TemplateLoader {
        private boolean throwException;
        private int findCount;

        private MockTemplateLoader() {
        }

        public void setThrowException(boolean throwException) {
            this.throwException = throwException;
        }

        public int getFindCount() {
            return this.findCount;
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            ++this.findCount;
            if (this.throwException) {
                throw new IOException("mock IO exception");
            }
            return null;
        }

        public long getLastModified(Object templateSource) {
            return 0L;
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return null;
        }
    }
}

