/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.ext.dom.NodeModel;
import freemarker.ext.jdom.NodeListModel;
import freemarker.template.Configuration;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.Template;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import freemarker.testcase.models.BooleanHash1;
import freemarker.testcase.models.BooleanHash2;
import freemarker.testcase.models.BooleanList1;
import freemarker.testcase.models.BooleanList2;
import freemarker.testcase.models.MultiModel1;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class TemplateTestCase
extends TestCase {
    Template template;
    HashMap dataModel = new HashMap();
    String filename;
    String testName;
    String inputDir = "template";
    String referenceDir = "reference";
    File outputDir;
    Configuration conf = new Configuration();

    public TemplateTestCase(String name, String filename) {
        super(name);
        this.filename = filename;
        this.testName = name;
    }

    public void setTemplateDirectory(String dirname) throws IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("TemplateTestCase.class");
        File parent = new File(url.getFile()).getParentFile();
        File dir = new File(parent, dirname);
        this.conf.setDirectoryForTemplateLoading(dir);
        System.out.println("Setting loading directory as: " + dir);
    }

    public void setOutputDirectory(String dirname) {
        URL url = ((Object)((Object)this)).getClass().getResource("TemplateTestCase.class");
        File parent = new File(url.getFile()).getParentFile();
        this.outputDir = new File(parent, dirname);
        System.out.println("Setting reference directory as: " + this.outputDir);
    }

    public void setConfigParam(String param, String value) throws IOException {
        if ("templatedir".equals(param)) {
            this.setTemplateDirectory(value);
        } else if ("auto_import".equals(param)) {
            String as;
            StringTokenizer st = new StringTokenizer(value);
            if (!st.hasMoreTokens()) {
                TemplateTestCase.fail((String)"Expecting libname");
            }
            String libname = st.nextToken();
            if (!st.hasMoreTokens()) {
                TemplateTestCase.fail((String)"Expecting 'as <alias>' in autoimport");
            }
            if (!(as = st.nextToken()).equals("as")) {
                TemplateTestCase.fail((String)"Expecting 'as <alias>' in autoimport");
            }
            if (!st.hasMoreTokens()) {
                TemplateTestCase.fail((String)"Expecting alias after 'as' in autoimport");
            }
            String alias = st.nextToken();
            this.conf.addAutoImport(alias, libname);
        } else if ("clear_encoding_map".equals(param)) {
            if (StringUtil.getYesNo(value)) {
                this.conf.clearEncodingMap();
            }
        } else if ("input_encoding".equals(param)) {
            this.conf.setDefaultEncoding(value);
        } else if ("outputdir".equals(param)) {
            this.setOutputDirectory(value);
        } else {
            try {
                this.conf.setSetting(param, value);
            }
            catch (TemplateException e) {
                throw new RuntimeException("Failed to set setting " + StringUtil.jQuote(param) + " to " + StringUtil.jQuote(value) + "; see cause exception.", e);
            }
        }
    }

    public void setUp() throws Exception {
        this.dataModel.put("message", "Hello, world!");
        if (this.testName.equals("bean-maps")) {
            BeansWrapper w1 = new BeansWrapper();
            BeansWrapper w2 = new BeansWrapper();
            BeansWrapper w3 = new BeansWrapper();
            BeansWrapper w4 = new BeansWrapper();
            BeansWrapper w5 = new BeansWrapper();
            BeansWrapper w6 = new BeansWrapper();
            BeansWrapper w7 = new BeansWrapper();
            w1.setExposureLevel(2);
            w2.setExposureLevel(2);
            w3.setExposureLevel(3);
            w4.setExposureLevel(3);
            w5.setExposureLevel(0);
            w6.setExposureLevel(0);
            w1.setMethodsShadowItems(true);
            w2.setMethodsShadowItems(false);
            w3.setMethodsShadowItems(true);
            w4.setMethodsShadowItems(false);
            w5.setMethodsShadowItems(true);
            w6.setMethodsShadowItems(false);
            w7.setSimpleMapWrapper(true);
            Object test = this.getTestBean();
            this.dataModel.put("m1", w1.wrap(test));
            this.dataModel.put("m2", w2.wrap(test));
            this.dataModel.put("m3", w3.wrap(test));
            this.dataModel.put("m4", w4.wrap(test));
            this.dataModel.put("m5", w5.wrap(test));
            this.dataModel.put("m6", w6.wrap(test));
            this.dataModel.put("m7", w7.wrap(test));
            this.dataModel.put("s1", w1.wrap("hello"));
            this.dataModel.put("s2", w1.wrap("world"));
            this.dataModel.put("s3", w5.wrap("hello"));
            this.dataModel.put("s4", w5.wrap("world"));
        } else if (this.testName.equals("beans")) {
            this.dataModel.put("array", new String[]{"array-0", "array-1"});
            this.dataModel.put("list", Arrays.asList("list-0", "list-1", "list-2"));
            HashMap<Object, String> tmap = new HashMap<Object, String>();
            tmap.put("key", "value");
            Object objKey = new Object();
            tmap.put(objKey, "objValue");
            this.dataModel.put("map", tmap);
            this.dataModel.put("objKey", objKey);
            this.dataModel.put("obj", TestCase.class.getClassLoader().loadClass("freemarker.testcase.models.BeanTestClass").newInstance());
            this.dataModel.put("resourceBundle", new ResourceBundleModel(ResourceBundle.getBundle("freemarker.testcase.models.BeansTestResources"), BeansWrapper.getDefaultInstance()));
            this.dataModel.put("date", new GregorianCalendar(1974, 10, 14).getTime());
            this.dataModel.put("statics", BeansWrapper.getDefaultInstance().getStaticModels());
            this.dataModel.put("enums", BeansWrapper.getDefaultInstance().getEnumModels());
        } else if (this.testName.equals("boolean")) {
            this.dataModel.put("boolean1", TemplateBooleanModel.FALSE);
            this.dataModel.put("boolean2", TemplateBooleanModel.TRUE);
            this.dataModel.put("boolean3", TemplateBooleanModel.TRUE);
            this.dataModel.put("boolean4", TemplateBooleanModel.TRUE);
            this.dataModel.put("boolean5", TemplateBooleanModel.FALSE);
            this.dataModel.put("list1", new BooleanList1());
            this.dataModel.put("list2", new BooleanList2());
            this.dataModel.put("hash1", new BooleanHash1());
            this.dataModel.put("hash2", new BooleanHash2());
        } else if (this.testName.equals("dateformat")) {
            GregorianCalendar cal = new GregorianCalendar(2002, 10, 15, 14, 54, 13);
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.dataModel.put("date", new SimpleDate(cal.getTime(), 3));
            this.dataModel.put("unknownDate", new SimpleDate(cal.getTime(), 0));
        } else if (this.testName.equals("number-format")) {
            this.dataModel.put("int", new SimpleNumber(new Integer(1)));
            this.dataModel.put("double", new SimpleNumber(new Double(1.0)));
            this.dataModel.put("double2", new SimpleNumber(new Double(1.000000000000001)));
            this.dataModel.put("double3", new SimpleNumber(new Double(1.0E-16)));
            this.dataModel.put("double4", new SimpleNumber(new Double(-1.0E-16)));
            this.dataModel.put("bigDecimal", new SimpleNumber(BigDecimal.valueOf(1L)));
            this.dataModel.put("bigDecimal2", new SimpleNumber(BigDecimal.valueOf(1L, 16)));
        } else if (this.testName.equals("default-xmlns")) {
            InputSource is = new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-defaultxmlns1.xml"));
            NodeModel nm = NodeModel.parse(is);
            this.dataModel.put("doc", nm);
        } else if (this.testName.equals("multimodels")) {
            this.dataModel.put("test", "selftest");
            this.dataModel.put("self", "self");
            this.dataModel.put("zero", new Integer(0));
            this.dataModel.put("data", new MultiModel1());
        } else if (this.testName.equals("nodelistmodel")) {
            Document doc = new SAXBuilder().build(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-xml.xml")));
            this.dataModel.put("doc", new NodeListModel(doc));
        } else if (this.testName.equals("test-stringbimethods")) {
            this.dataModel.put("multi", new TestBoolean());
        } else if (this.testName.equals("type-builtins")) {
            this.dataModel.put("testmethod", new TestMethod());
            this.dataModel.put("testnode", new TestNode());
            this.dataModel.put("testcollection", new SimpleCollection(new ArrayList()));
        } else if (this.testName.equals("var-layers")) {
            this.dataModel.put("x", new Integer(4));
            this.dataModel.put("z", new Integer(4));
            this.conf.setSharedVariable("y", new Integer(7));
        } else if (this.testName.equals("xml-fragment")) {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            DocumentBuilder db = f.newDocumentBuilder();
            org.w3c.dom.Document doc = db.parse(new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-xmlfragment.xml")));
            this.dataModel.put("node", NodeModel.wrap(doc.getDocumentElement().getFirstChild().getFirstChild()));
        } else if (this.testName.equals("xmlns1")) {
            InputSource is = new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-xmlns.xml"));
            NodeModel nm = NodeModel.parse(is);
            this.dataModel.put("doc", nm);
        } else if (this.testName.equals("xmlns2")) {
            InputSource is = new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-xmlns2.xml"));
            NodeModel nm = NodeModel.parse(is);
            this.dataModel.put("doc", nm);
        } else if (this.testName.equals("xmlns3") || this.testName.equals("xmlns4")) {
            InputSource is = new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-xmlns3.xml"));
            NodeModel nm = NodeModel.parse(is);
            this.dataModel.put("doc", nm);
        } else if (this.testName.equals("xmlns5")) {
            InputSource is = new InputSource(((Object)((Object)this)).getClass().getResourceAsStream("test-defaultxmlns1.xml"));
            NodeModel nm = NodeModel.parse(is);
            this.dataModel.put("doc", nm);
        } else if (this.testName.startsWith("sequence-builtins-with-")) {
            TreeSet<String> abcSet = new TreeSet<String>();
            abcSet.add("a");
            abcSet.add("b");
            abcSet.add("c");
            this.dataModel.put("abcSet", abcSet);
        } else if (this.testName.equals("test-iso8601")) {
            this.dataModel.put("javaGMT02", TimeZone.getTimeZone("GMT+02"));
            this.dataModel.put("javaUTC", TimeZone.getTimeZone("UTC"));
            this.dataModel.put("adaptedToStringScalar", new Object(){

                public String toString() {
                    return "GMT+02";
                }
            });
        } else if (this.testName.equals("test-number-to-date")) {
            this.dataModel.put("bigInteger", new BigInteger("1305575275540"));
            this.dataModel.put("bigDecimal", new BigDecimal("1305575275539.5"));
        }
    }

    public void runTest() {
        PrintWriter pw;
        StringWriter sw;
        try {
            this.template = this.conf.getTemplate(this.filename);
        }
        catch (Exception e) {
            StringWriter sw2 = new StringWriter();
            PrintWriter pw2 = new PrintWriter(sw2);
            e.printStackTrace(pw2);
            TemplateTestCase.fail((String)("Could not load template " + this.filename + "\n" + sw2.toString()));
        }
        File refFile = new File(this.outputDir, this.filename);
        File outFile = new File(this.outputDir, String.valueOf(this.filename) + ".out");
        OutputStreamWriter out = null;
        String encoding = this.conf.getOutputEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding);
        }
        catch (IOException ioe) {
            TemplateTestCase.fail((String)("Cannot write to file: " + outFile + "\n" + ioe.getMessage()));
        }
        try {
            this.template.process(this.dataModel, out);
            ((Writer)out).close();
        }
        catch (Exception e) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            TemplateTestCase.fail((String)("Could not process template " + this.filename + "\n" + sw.toString()));
        }
        try {
            InputStreamReader ref = new InputStreamReader((InputStream)new FileInputStream(refFile), encoding);
            InputStreamReader output = new InputStreamReader((InputStream)new FileInputStream(outFile), encoding);
            System.out.println(outFile);
            TemplateTestCase.compare(ref, output);
            outFile.delete();
        }
        catch (IOException e) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            TemplateTestCase.fail((String)("Error comparing files " + refFile + " and " + outFile + "\n" + sw.toString()));
        }
    }

    public static void compare(Reader reference, Reader output) throws IOException {
        LineNumberReader ref = new LineNumberReader(reference);
        LineNumberReader out = new LineNumberReader(output);
        String refLine = "";
        String outLine = "";
        while (refLine != null || outLine != null) {
            if (refLine == null) {
                TemplateTestCase.fail((String)"Output text is longer than reference text");
            }
            if (outLine == null) {
                TemplateTestCase.fail((String)"Output text is shorter than reference text");
            }
            refLine = ref.readLine();
            outLine = out.readLine();
            if (refLine == null || !(outLine != null & !refLine.equals(outLine))) continue;
            TemplateTestCase.fail((String)("Difference found on line " + ref.getLineNumber() + ".\nReference text is: " + refLine + "\nOutput text is: " + outLine));
        }
    }

    public Object getTestBean() {
        TestBean testBean = new TestBean();
        testBean.put("name", "Chris");
        testBean.put("location", "San Francisco");
        testBean.put("age", new Integer(27));
        return testBean;
    }

    public static class TestBean
    extends HashMap {
        public String getName() {
            return "Christopher";
        }

        public int getLuckyNumber() {
            return 7;
        }
    }

    static class TestBoolean
    implements TemplateBooleanModel,
    TemplateScalarModel {
        TestBoolean() {
        }

        public boolean getAsBoolean() {
            return true;
        }

        public String getAsString() {
            return "de";
        }
    }

    static class TestMethod
    implements TemplateMethodModel {
        TestMethod() {
        }

        public Object exec(List arguments) {
            return "x";
        }
    }

    static class TestNode
    implements TemplateNodeModel {
        TestNode() {
        }

        public String getNodeName() {
            return "name";
        }

        public TemplateNodeModel getParentNode() {
            return null;
        }

        public String getNodeType() {
            return "element";
        }

        public TemplateSequenceModel getChildNodes() {
            return null;
        }

        public String getNodeNamespace() {
            return null;
        }
    }
}

