/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.ext.dom.NodeModel;
import freemarker.testcase.TemplateTestCase;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateTestSuite
extends TestSuite {
    private Map configParams = new LinkedHashMap();

    public static TestSuite suite() throws Exception {
        return new TemplateTestSuite();
    }

    public TemplateTestSuite() throws Exception {
        NodeModel.useJaxenXPathSupport();
        this.readConfig();
    }

    void readConfig() throws Exception {
        URL url = TemplateTestSuite.class.getResource("testcases.xml");
        File f = new File(url.getFile());
        this.readConfig(f);
    }

    public void readConfig(File f) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse(f);
        Element root = d.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                if (n.getNodeName().equals("config")) {
                    NamedNodeMap atts = n.getAttributes();
                    int j = 0;
                    while (j < atts.getLength()) {
                        Attr att = (Attr)atts.item(j);
                        this.configParams.put(att.getName(), att.getValue());
                        ++j;
                    }
                }
                if (n.getNodeName().equals("testcase")) {
                    TestCase tc = this.createTestCaseFromNode((Element)n);
                    this.addTest((Test)tc);
                }
            }
            ++i;
        }
    }

    String getTextInElement(Element e) {
        StringBuffer buf = new StringBuffer();
        NodeList children = e.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            short type = n.getNodeType();
            if (type == 3 || type == 4) {
                buf.append(n.getNodeValue());
            }
            ++i;
        }
        return buf.toString();
    }

    TestCase createTestCaseFromNode(Element e) throws Exception {
        String filename = e.getAttribute("filename");
        String name = e.getAttribute("name");
        String classname = e.getAttribute("class");
        if (classname != null && classname.length() > 0) {
            Class<?> cl = Class.forName(classname);
            Constructor<?> cons = cl.getConstructor(String.class, String.class);
            return (TestCase)cons.newInstance(name, filename);
        }
        TemplateTestCase result = new TemplateTestCase(name, filename);
        for (Map.Entry entry : this.configParams.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            System.out.println("Setting " + key + " to " + value);
            result.setConfigParam(entry.getKey().toString(), entry.getValue().toString());
        }
        NodeList configs = e.getElementsByTagName("config");
        int i = 0;
        while (i < configs.getLength()) {
            NamedNodeMap atts = configs.item(i).getAttributes();
            int j = 0;
            while (j < atts.getLength()) {
                Attr att = (Attr)atts.item(j);
                result.setConfigParam(att.getName(), att.getValue());
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)new TemplateTestSuite());
    }
}

