/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase;

import freemarker.template.Template;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class TreeView {
    public static void main(String[] args) {
        if (args.length == 0) {
            TreeView.usage();
            return;
        }
        String filename = args[0];
        Template t = null;
        try {
            t = new Template(filename, new FileReader(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        TreeView.showTree(t);
    }

    static void showTree(Template t) {
        JTree tree = new JTree(t.getRootTreeNode());
        JFrame jf = new JFrame(t.getName());
        jf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JScrollPane scrollPane = new JScrollPane(tree);
        jf.getContentPane().add(scrollPane);
        jf.pack();
        jf.show();
    }

    static void usage() {
        System.err.println("little toy program to display a compiled template as a tree.");
        System.err.println("Usage: java freemarker.testcase.TreeView <templatefile>");
    }
}

