/*
 * Decompiled with CFR 0.152.
 */
package freemarker.testcase.models;

import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class TransformModel1
implements TemplateTransformModel {
    private boolean m_bAmpersands = false;
    private boolean m_bQuotes = false;
    private boolean m_bTags = false;
    private String m_aComment = "";
    private static final int READER_BUFFER_SIZE = 4096;

    public Writer getWriter(final Writer out, Map args) {
        final StringBuffer buf = new StringBuffer();
        return new Writer(out){

            public void write(char[] cbuf, int off, int len) {
                buf.append(cbuf, off, len);
            }

            public void flush() {
            }

            public void close() throws IOException {
                StringReader sr = new StringReader(buf.toString());
                StringWriter sw = new StringWriter();
                TransformModel1.this.transform(sr, sw);
                out.write(sw.toString());
            }
        };
    }

    public void setAmpersands(boolean bAmpersands) {
        this.m_bAmpersands = bAmpersands;
    }

    public void setQuotes(boolean bQuotes) {
        this.m_bQuotes = bQuotes;
    }

    public void setTags(boolean bTags) {
        this.m_bTags = bTags;
    }

    public void setComment(String aComment) {
        this.m_aComment = aComment;
    }

    public void transform(Reader source, Writer output) throws IOException {
        int n = 0;
        boolean bCommentSent = false;
        char[] aBuffer = new char[4096];
        int i = source.read(aBuffer);
        while (i >= 0) {
            int j = 0;
            while (j < i) {
                char c = aBuffer[j];
                switch (c) {
                    case '&': {
                        if (this.m_bAmpersands) {
                            output.write("&amp;");
                            break;
                        }
                        output.write(c);
                        break;
                    }
                    case '<': {
                        if (this.m_bTags) {
                            output.write("&lt;");
                            break;
                        }
                        output.write(c);
                        break;
                    }
                    case '>': {
                        if (this.m_bTags) {
                            output.write("&gt;");
                            break;
                        }
                        output.write(c);
                        break;
                    }
                    case '\"': {
                        if (this.m_bQuotes) {
                            output.write("&quot;");
                            break;
                        }
                        output.write(c);
                        break;
                    }
                    case '\'': {
                        if (this.m_bQuotes) {
                            output.write("&apos;");
                            break;
                        }
                        output.write(c);
                        break;
                    }
                    case '*': {
                        if (!bCommentSent) {
                            output.write(this.m_aComment);
                            bCommentSent = true;
                            break;
                        }
                        output.write(c);
                        break;
                    }
                    default: {
                        output.write(c);
                    }
                }
                ++n;
                ++j;
            }
            i = source.read(aBuffer);
        }
    }
}

