/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISAllowableAction;
import org.apache.chemistry.abdera.ext.CMISAllowableActions;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class AllowableActionsTest
extends TCKTest {
    public void testFolderAllowableActions() throws Exception {
        Entry folder = this.fixture.createTestFolder("testAllowableActions");
        Link allowableActionsLink = folder.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions");
        GetRequest req = new GetRequest(allowableActionsLink.getHref().toString());
        Response allowableActionsRes = this.client.executeRequest(req, 200);
        Assert.assertNotNull((Object)allowableActionsRes);
        Element allowableActions = this.model.parse((Reader)new StringReader(allowableActionsRes.getContentAsString()), null);
        Assert.assertNotNull((Object)allowableActions);
        Assert.assertTrue((boolean)(allowableActions instanceof CMISAllowableActions));
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("includeAllowableActions", "true");
        Entry properties = this.client.getEntry(folder.getSelfLink().getHref(), args);
        Assert.assertNotNull((Object)properties);
        CMISObject propObject = (CMISObject)properties.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)propObject);
        CMISAllowableActions propAllowableActions = (CMISAllowableActions)propObject.getExtension(CMISConstants.ALLOWABLE_ACTIONS);
        Assert.assertNotNull((Object)propAllowableActions);
        AllowableActionsTest.compareAllowableActions((CMISAllowableActions)allowableActions, propAllowableActions);
    }

    public void testDocumentAllowableActions() throws Exception {
        Entry document = this.fixture.createTestDocument("testDocumentAllowableActions");
        Link allowableActionsLink = document.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions");
        GetRequest req = new GetRequest(allowableActionsLink.getHref().toString());
        Response allowableActionsRes = this.client.executeRequest(req, 200);
        Assert.assertNotNull((Object)allowableActionsRes);
        Element allowableActions = this.model.parse((Reader)new StringReader(allowableActionsRes.getContentAsString()), null);
        Assert.assertNotNull((Object)allowableActions);
        Assert.assertTrue((boolean)(allowableActions instanceof CMISAllowableActions));
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("includeAllowableActions", "true");
        Entry properties = this.client.getEntry(document.getSelfLink().getHref(), args);
        Assert.assertNotNull((Object)properties);
        CMISObject propObject = (CMISObject)properties.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)propObject);
        CMISAllowableActions propAllowableActions = (CMISAllowableActions)propObject.getExtension(CMISConstants.ALLOWABLE_ACTIONS);
        Assert.assertNotNull((Object)propAllowableActions);
        AllowableActionsTest.compareAllowableActions((CMISAllowableActions)allowableActions, propAllowableActions);
    }

    public void testGetChildrenAllowableActions() throws Exception {
        this.fixture.createTestFolder("testAllowableActions");
        this.fixture.createTestDocument("testDocumentAllowableActions");
        Entry testCase = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testCase);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("includeAllowableActions", "true");
        Feed children = this.client.getFeed(childrenLink.getHref(), args);
        Assert.assertNotNull((Object)children);
        for (Entry child : children.getEntries()) {
            CMISObject childObject = (CMISObject)child.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)childObject);
            CMISAllowableActions objectAllowableActions = (CMISAllowableActions)childObject.getExtension(CMISConstants.ALLOWABLE_ACTIONS);
            Assert.assertNotNull((Object)objectAllowableActions);
            Link allowableActionsLink = child.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions");
            GetRequest req = new GetRequest(allowableActionsLink.getHref().toString());
            Response allowableActionsRes = this.client.executeRequest(req, 200);
            Assert.assertNotNull((Object)allowableActionsRes);
            Element allowableActions = this.model.parse((Reader)new StringReader(allowableActionsRes.getContentAsString()), null);
            Assert.assertNotNull((Object)allowableActions);
            Assert.assertTrue((boolean)(allowableActions instanceof CMISAllowableActions));
            AllowableActionsTest.compareAllowableActions((CMISAllowableActions)allowableActions, objectAllowableActions);
        }
    }

    public static void compareAllowableActions(CMISAllowableActions left, CMISAllowableActions right) {
        ArrayList rightactions = new ArrayList(right.getNames());
        for (String action : left.getNames()) {
            Assert.assertTrue((boolean)rightactions.contains(action));
            CMISAllowableAction leftAction = left.find(action);
            Assert.assertNotNull((Object)leftAction);
            CMISAllowableAction rightAction = right.find(action);
            Assert.assertNotNull((Object)rightAction);
            Assert.assertEquals((Object)leftAction.isAllowed(), (Object)rightAction.isAllowed());
            rightactions.remove(action);
        }
        Assert.assertTrue((rightactions.size() == 0 ? 1 : 0) != 0);
    }
}

