/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.DeleteRequest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.PutRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class ContentStreamTest
extends TCKTest {
    public void testContentStreamEmpty() throws Exception {
        Entry document = this.fixture.createTestDocument("testContent", "createdocumentNoContent.atomentry.xml", true);
        Link editMediaLink = document.getEditMediaLink();
        Assert.assertNotNull((Object)editMediaLink);
        this.client.executeRequest(new GetRequest(editMediaLink.getHref().toString()), 404, 409);
    }

    public void testCreateContentStream() throws Exception {
        Entry document = this.fixture.createTestDocument("testContent", "createdocumentNoContent.atomentry.xml", true);
        String CREATED_CONTENT = "Created via SetContentStream()";
        Link editMediaLink = document.getEditMediaLink();
        Assert.assertNotNull((Object)editMediaLink);
        PutRequest putReq = new PutRequest(editMediaLink.getHref().toString(), CREATED_CONTENT, "text/plain");
        Response res = this.client.executeRequest(putReq, 200, 201);
        Assert.assertNotNull((Object)res);
    }

    public void testUpdateContentStream() throws Exception {
        Entry document = this.fixture.createTestDocument("testContent");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        String UPDATED_CONTENT = "Updated via SetContentStream()";
        Link editMediaLink = document.getEditMediaLink();
        Assert.assertNotNull((Object)editMediaLink);
        PutRequest putReq = new PutRequest(editMediaLink.getHref().toString(), UPDATED_CONTENT, "text/plain");
        Response res = this.client.executeRequest(putReq, 200, 201);
        Assert.assertNotNull((Object)res);
        GetRequest getReq = new GetRequest(document.getContentSrc().toString());
        Response documentUpdatedContentRes = this.client.executeRequest(getReq, 200);
        String resUpdatedContent = documentUpdatedContentRes.getContentAsString();
        Assert.assertEquals((Object)UPDATED_CONTENT, (Object)resUpdatedContent);
    }

    public void testDeleteContentStream() throws Exception {
        Entry document = this.fixture.createTestDocument("testContent");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Link editMediaLink = document.getEditMediaLink();
        Assert.assertNotNull((Object)editMediaLink);
        Response res = this.client.executeRequest(new DeleteRequest(editMediaLink.getHref().toString()), 204);
        Assert.assertNotNull((Object)res);
        this.client.getEntry(document.getSelfLink().getHref());
        this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 404, 409);
    }
}

