/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.BitSet;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class TableRow
extends TableFObj {
    private LengthRangeProperty blockProgressionDimension;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int breakAfter;
    private int breakBefore;
    private Length height;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private boolean setup = false;
    protected List pendingSpans;
    protected BitSet usedColumnIndices;
    private int columnIndex = 1;

    public TableRow(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.height = pList.get(106).getLength();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        super.bind(pList);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList pList) throws FOPException {
        if (!this.inMarker()) {
            TableBody body = (TableBody)this.parent;
            body.resetColumnIndex();
            this.pendingSpans = body.pendingSpans;
            this.usedColumnIndices = body.usedColumnIndices;
            while (this.usedColumnIndices.get(this.columnIndex - 1)) {
                ++this.columnIndex;
            }
        }
        super.processNode(elementName, locator, attlist, pList);
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (!this.inMarker()) {
            Table t = this.getTable();
            TableBody body = (TableBody)this.getParent();
            if (body.isFirst(this)) {
                TableCell cell = (TableCell)child;
                int colNr = cell.getColumnNumber();
                int colSpan = cell.getNumberColumnsSpanned();
                Length colWidth = null;
                if (cell.getWidth().getEnum() != 9 && colSpan == 1) {
                    colWidth = cell.getWidth();
                }
                for (int i = colNr; i < colNr + colSpan; ++i) {
                    if (t.columns.size() < i || t.columns.get(i - 1) == null) {
                        t.addDefaultColumn(colWidth, i == colNr ? cell.getColumnNumber() : 0);
                        continue;
                    }
                    TableColumn col = (TableColumn)t.columns.get(i - 1);
                    if (col.isDefaultColumn() || colWidth == null) continue;
                    col.setColumnWidth(colWidth);
                }
            }
        }
        super.addChildNode(child);
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startRow(this);
    }

    protected void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(table-cell+)");
        }
        if (!this.inMarker()) {
            this.pendingSpans = null;
            this.usedColumnIndices = null;
        }
        this.getFOEventHandler().endRow(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (!"http://www.w3.org/1999/XSL/Format".equals(nsURI) || !localName.equals("table-cell")) {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().getWithinPage().isAuto() || !this.getKeepWithNext().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().getWithinPage().isAuto() || !this.getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-row";
    }

    public int getNameId() {
        return 54;
    }

    public int getCurrentColumnIndex() {
        return this.columnIndex;
    }

    public void setCurrentColumnIndex(int newIndex) {
        this.columnIndex = newIndex;
    }

    public boolean isColumnNumberUsed(int colNr) {
        return this.usedColumnIndices.get(colNr - 1);
    }

    protected void flagColumnIndices(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.usedColumnIndices.set(i);
        }
        while (this.usedColumnIndices.get(this.columnIndex - 1)) {
            ++this.columnIndex;
        }
    }
}

