/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.spreadsheet.ColCount;
import com.google.gdata.data.spreadsheet.RowCount;
import com.google.gdata.util.Version;
import java.net.MalformedURLException;
import java.net.URL;

@Kind.Term(value="http://schemas.google.com/spreadsheets/2006#worksheet")
public class WorksheetEntry
extends BaseEntry<WorksheetEntry> {
    public static final String KIND = "http://schemas.google.com/spreadsheets/2006#worksheet";
    public static final Category CATEGORY = new Category("http://schemas.google.com/spreadsheets/2006", "http://schemas.google.com/spreadsheets/2006#worksheet");

    public WorksheetEntry() {
        this.getCategories().add(CATEGORY);
    }

    public WorksheetEntry(int rowCount, int colCount) {
        this.getCategories().add(CATEGORY);
        this.addExtension(new RowCount(rowCount));
        this.addExtension(new ColCount(colCount));
    }

    public WorksheetEntry(BaseEntry sourceEntry) {
        super(sourceEntry);
        this.getCategories().add(CATEGORY);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(WorksheetEntry.class, RowCount.getDefaultDescription());
        extProfile.declare(WorksheetEntry.class, ColCount.getDefaultDescription());
    }

    public URL getListFeedUrl() {
        try {
            return new URL(this.getFeedUrlString("http://schemas.google.com/spreadsheets/2006#listfeed"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in GData server", e);
        }
    }

    public URL getCellFeedUrl() {
        try {
            return new URL(this.getFeedUrlString("http://schemas.google.com/spreadsheets/2006#cellsfeed"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in GData server", e);
        }
    }

    private String getFeedUrlString(String linkRelKind) {
        Version spreadsheetVersion = this.state.service.getProtocolVersion();
        if (spreadsheetVersion.isCompatible(SpreadsheetService.Versions.V1)) {
            Link feedLink = this.getLink(linkRelKind, ILink.Type.ATOM);
            return feedLink.getHref();
        }
        if (linkRelKind.equals("http://schemas.google.com/spreadsheets/2006#listfeed")) {
            return ((OutOfLineContent)this.getContent()).getUri();
        }
        Link feedLink = this.getLink(linkRelKind, ILink.Type.ATOM);
        return feedLink.getHref();
    }

    public int getRowCount() {
        RowCount count = (RowCount)this.getExtension(RowCount.class);
        if (count != null) {
            return count.getCount();
        }
        return 0;
    }

    public void setRowCount(int count) {
        this.setExtension(new RowCount(count));
    }

    public int getColCount() {
        ColCount count = (ColCount)this.getExtension(ColCount.class);
        if (count != null) {
            return count.getCount();
        }
        return 0;
    }

    public void setColCount(int count) {
        this.setExtension(new ColCount(count));
    }
}

