/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.html.wikipedia;

import info.bliki.html.wikipedia.HTMLTag;
import info.bliki.html.wikipedia.ToWikipedia;
import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;

public abstract class AbstractHTMLTag
implements HTMLTag {
    boolean fNoNewLine;

    public AbstractHTMLTag() {
        this(false);
    }

    public AbstractHTMLTag(boolean noNewLine) {
        this.fNoNewLine = noNewLine;
    }

    public void open(TagNode node, StringBuilder resultBuffer) {
    }

    public void content(ToWikipedia w, TagNode node, StringBuilder resultBuffer, boolean showWithoutTag) {
        List children = node.getChildren();
        if (children.size() != 0) {
            if (!showWithoutTag) {
                this.open(node, resultBuffer);
            }
            if (this.fNoNewLine) {
                StringBuilder buf = new StringBuilder();
                w.nodesToText(children, buf);
                int i = 0;
                while (i < buf.length()) {
                    char ch = buf.charAt(i);
                    if (ch == '\n' || ch == '\r' || ch == '\t') {
                        buf.setCharAt(i, ' ');
                    }
                    ++i;
                }
                String str = buf.toString();
                str = str.trim();
                resultBuffer.append(str);
            } else {
                w.nodesToText(children, resultBuffer);
            }
            if (!showWithoutTag) {
                this.close(node, resultBuffer);
            }
        }
    }

    public void close(TagNode node, StringBuilder resultBuffer) {
    }

    public BaseToken getFirstContent(List children, String tagName) {
        if (children.size() != 0) {
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) != null) {
                    if (children.get(i) instanceof ContentToken && ((ContentToken)children.get(i)).getContent().length() > 0) {
                        return (ContentToken)children.get(i);
                    }
                    if (children.get(i) instanceof TagNode && ((TagNode)children.get(i)).getName().equals(tagName)) {
                        return (TagNode)children.get(i);
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

